/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.cursewrapper;

import java.nio.file.Path;
import org.moddingx.cursewrapper.cache.CurseCache;
import org.moddingx.cursewrapper.route.ChangelogRoute;
import org.moddingx.cursewrapper.route.FileRoute;
import org.moddingx.cursewrapper.route.FilesRoute;
import org.moddingx.cursewrapper.route.LatestFileRoute;
import org.moddingx.cursewrapper.route.ProjectRoute;
import org.moddingx.cursewrapper.route.ProjectsRoute;
import org.moddingx.cursewrapper.route.SearchRoute;
import org.moddingx.cursewrapper.route.SlugRoute;
import org.moddingx.cursewrapper.route.VersionRoute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Route;
import spark.Service;

public class CurseServer {
    private static final Logger logger = LoggerFactory.getLogger(CurseServer.class);
    private final String version;
    private final Service spark;

    public CurseServer(String version, int port, SslData ssl, int threads, CurseCache cache) {
        logger.info("Starting Server on port {}.", (Object)port);
        this.version = version;
        this.spark = Service.ignite();
        this.spark.port(port);
        logger.info("Running on {} threads.", (Object)threads);
        this.spark.threadPool(threads, threads, -1);
        if (ssl != null) {
            this.spark.secure(ssl.cert().toAbsolutePath().normalize().toString(), ssl.key(), null, null);
        } else {
            logger.warn("Running without SSL.");
        }
        this.spark.get("/version", (Route)new VersionRoute(this.spark, cache, version));
        this.spark.get("/search", (Route)new SearchRoute(this.spark, cache));
        this.spark.get("/slug/:projectId", (Route)new SlugRoute(this.spark, cache));
        this.spark.get("/project/:projectId", (Route)new ProjectRoute(this.spark, cache));
        this.spark.get("/project/:projectId/files", (Route)new FilesRoute(this.spark, cache));
        this.spark.get("/project/:projectId/latest", (Route)new LatestFileRoute(this.spark, cache));
        this.spark.get("/project/:projectId/file/:fileId", (Route)new FileRoute(this.spark, cache));
        this.spark.get("/project/:projectId/changelog/:fileId", (Route)new ChangelogRoute(this.spark, cache));
        this.spark.get("/projects", (Route)new ProjectsRoute(this.spark, cache));
        this.spark.awaitInitialization();
        logger.info("Server started.");
    }

    public String version() {
        return this.version;
    }

    public void shutdown() {
        this.spark.stop();
    }

    public record SslData(String key, Path cert) {
    }
}

