/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.cursewrapper;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.Manifest;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import org.moddingx.cursewrapper.CurseServer;
import org.moddingx.cursewrapper.backend.CurseApi;
import org.moddingx.cursewrapper.cache.CurseCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) throws IOException {
        String token;
        int port;
        String version = null;
        try (InputStream in2 = Main.class.getResourceAsStream("/META-INF/MANIFEST.MF");){
            if (in2 != null) {
                Manifest manifest = new Manifest(in2);
                version = manifest.getMainAttributes().getValue("Implementation-Version");
            }
        }
        catch (Exception in2) {
            // empty catch block
        }
        OptionParser options = new OptionParser(false);
        OptionSpecBuilder specDocker = options.accepts("docker", "Run in Docker mode. This will load secrets as docker secrets.");
        ArgumentAcceptingOptionSpec specToken = options.accepts("token", "The CurseForge API token to use").availableUnless((OptionSpec)specDocker, new OptionSpec[0]).requiredUnless((OptionSpec)specDocker, new OptionSpec[0]).withRequiredArg();
        OptionSpecBuilder specNoSsl = options.accepts("no-ssl", "Disable SSL. For testing only.");
        ArgumentAcceptingOptionSpec specSsl = options.accepts("ssl", "The SSL certificate fle to use.").availableUnless((OptionSpec)specDocker, new OptionSpec[]{specNoSsl}).withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.FILE_EXISTING, PathProperties.READABLE}));
        ArgumentAcceptingOptionSpec specSslKey = options.accepts("ssl-key", "The password of the SSL certificate.").availableUnless((OptionSpec)specDocker, new OptionSpec[]{specNoSsl}).withRequiredArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec specPort = options.accepts("port", "The port to run on.").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec specThreads = options.accepts("threads", "How many threads the server should use.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Math.min(4, Runtime.getRuntime().availableProcessors()), (Object[])new Integer[0]);
        OptionSet set = options.parse(args);
        if (version == null) {
            logger.warn("Failed to detect version, falling back to 'UNKNOWN'");
            version = "UNKNOWN";
        } else {
            logger.info("Running CurseWrapper v" + version);
        }
        boolean docker = set.has((OptionSpec)specDocker);
        boolean useSsl = !set.has((OptionSpec)specNoSsl);
        CurseServer.SslData ssl = null;
        int n = set.has((OptionSpec)specPort) ? (Integer)set.valueOf((OptionSpec)specPort) : (port = useSsl ? 443 : 80);
        if (docker) {
            token = Main.dockerSecret("curse_token");
            if (useSsl) {
                ssl = new CurseServer.SslData(Main.dockerSecret("ssl_keystore_password"), Main.dockerSecretPath("ssl_keystore"));
            }
        } else {
            token = (String)set.valueOf((OptionSpec)specToken);
            if (useSsl) {
                ssl = new CurseServer.SslData((String)set.valueOf((OptionSpec)specSslKey), ((Path)set.valueOf((OptionSpec)specSsl)).toAbsolutePath().normalize());
            }
        }
        CurseApi api = new CurseApi(token);
        api.testToken();
        CurseCache cache = new CurseCache(api);
        CurseServer server = new CurseServer(version, port, ssl, (Integer)set.valueOf((OptionSpec)specThreads), cache);
        Runtime.getRuntime().addShutdownHook(new Thread(server::shutdown));
        logger.info("Initialisation done.");
    }

    private static String dockerSecret(String id) throws IOException {
        return Files.readString(Main.dockerSecretPath(id));
    }

    private static Path dockerSecretPath(String id) {
        return Paths.get("/", "run", "secrets", id);
    }
}

