/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.cursewrapper.backend.data.util;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;

public class DateFactory
implements TypeAdapterFactory {
    @Nullable
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (type.getRawType() == Date.class) {
            return DateAdapter.INSTANCE;
        }
        return null;
    }

    private static class DateAdapter
    extends TypeAdapter<Date> {
        public static final DateAdapter INSTANCE = new DateAdapter();
        private static final SimpleDateFormat CURSE_ALTERNATIVE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

        private DateAdapter() {
        }

        public void write(JsonWriter out, Date value) throws IOException {
            out.value(ISO8601Utils.format((Date)value));
        }

        public Date read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String dateStr = in.nextString();
            try {
                return ISO8601Utils.parse((String)dateStr, (ParsePosition)new ParsePosition(0));
            }
            catch (ParseException e) {
                return CURSE_ALTERNATIVE_FORMAT.parse(dateStr, new ParsePosition(0));
            }
        }
    }
}

