/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.cursewrapper.backend.data.util;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.moddingx.cursewrapper.backend.data.structure.CurseEnum;

public class EnumFactory
implements TypeAdapterFactory {
    private final Map<Class<?>, EnumAdapter<?>> instances = new HashMap();

    @Nullable
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (type.getRawType().isEnum() && CurseEnum.class.isAssignableFrom(type.getRawType())) {
            return this.instances.computeIfAbsent(type.getRawType(), cls -> new EnumAdapter(cls));
        }
        return null;
    }

    private static class EnumAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Class<T> cls;
        private final List<T> values;
        private final T defaultValue;

        private EnumAdapter(Class<T> cls) {
            this.cls = cls;
            this.values = Arrays.stream((Enum[])cls.getEnumConstants()).toList();
            Object defaultValue = null;
            try {
                defaultValue = Enum.valueOf(cls, "OTHER");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.defaultValue = defaultValue;
        }

        public void write(JsonWriter out, T value) throws IOException {
            out.value((long)((Enum)value).ordinal());
        }

        public T read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return this.defaultValue;
            }
            int idx = in.nextInt();
            if (idx > 0 && idx < this.values.size()) {
                return (T)((Enum)this.values.get(idx));
            }
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            throw new JsonParseException("Invalid enum constant " + idx + " for " + this.cls.getSimpleName());
        }
    }
}

