/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.cursewrapper.cache;

import java.util.List;
import java.util.Optional;
import org.moddingx.cursewrapper.api.response.FileInfo;
import org.moddingx.cursewrapper.api.response.ModLoader;
import org.moddingx.cursewrapper.api.response.ProjectInfo;

public class CacheKey<K, V> {
    public static final CacheKey<Integer, String> SLUG = new CacheKey(600, 18000000);
    public static final CacheKey<Integer, ProjectInfo> PROJECT = new CacheKey(400, 10800000);
    public static final CacheKey<FileKey, FileInfo> FILE = new CacheKey(2000, 10800000);
    public static final CacheKey<FileKey, String> CHANGELOG = new CacheKey(300, 3600000);
    public static final CacheKey<SearchKey, List<Integer>> SEARCH = new CacheKey(200, 1800000);
    public static final CacheKey<FilesKey, List<FileKey>> FILES = new CacheKey(200, 1800000);
    public static final CacheKey<FilesKey, Optional<FileKey>> LATEST_FILE = new CacheKey(100, 300000);
    public final int size;
    public final int cacheTimeMillis;

    private CacheKey(int size, int cacheTime) {
        this.size = size;
        this.cacheTimeMillis = cacheTime;
    }

    public record FilesKey(int projectId, Optional<ModLoader> loader, Optional<String> version) {
    }

    public record SearchKey(String query, Optional<ModLoader> loader, Optional<String> version) {
    }

    public record FileKey(int projectId, int fileId) {
    }
}

