/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.cursewrapper.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.moddingx.cursewrapper.cache.CacheFunction;
import org.moddingx.cursewrapper.cache.CacheKey;
import org.moddingx.cursewrapper.cache.CurseCache;

public class CacheUtils {
    public static <T, M, R> List<R> bulkMap(CurseCache cache, CacheKey<T, R> key, List<T> entries, CacheFunction<T, R> singleResolver, CacheFunction<Set<T>, Map<T, R>> bulkResolver) throws IOException {
        HashSet<T> keys = new HashSet<T>();
        ArrayList<R> resultList = new ArrayList<R>(entries.size());
        for (T entry : entries) {
            Optional<R> cacheHit = cache.getCached(key, entry);
            if (cacheHit.isPresent()) {
                resultList.add(cacheHit.get());
                continue;
            }
            resultList.add(null);
            keys.add(entry);
        }
        if (!keys.isEmpty()) {
            Map<T, R> resolved = bulkResolver.apply(cache.api, keys);
            for (int i = 0; i < entries.size(); ++i) {
                if (resultList.get(i) != null) continue;
                T entryKey = entries.get(i);
                if (resolved.containsKey(entryKey)) {
                    R entryValue = resolved.get(entryKey);
                    resultList.set(i, entryValue);
                    cache.store(key, entryKey, entryValue);
                    continue;
                }
                resultList.set(i, cache.get(key, entryKey, singleResolver));
            }
        }
        return List.copyOf(resultList);
    }
}

