/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.cursewrapper.cache;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.moddingx.cursewrapper.backend.CurseApi;
import org.moddingx.cursewrapper.cache.CacheFunction;
import org.moddingx.cursewrapper.cache.CacheKey;

public class CurseCache {
    public final CurseApi api;
    private final Map<CacheKey<?, ?>, Cache<?, ?>> caches;

    public CurseCache(CurseApi api) {
        this.api = api;
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        HashMap map = new HashMap();
        CurseCache.addCache(api, CacheKey.SLUG, map, executor);
        CurseCache.addCache(api, CacheKey.PROJECT, map, executor);
        CurseCache.addCache(api, CacheKey.FILE, map, executor);
        CurseCache.addCache(api, CacheKey.CHANGELOG, map, executor);
        CurseCache.addCache(api, CacheKey.SEARCH, map, executor);
        CurseCache.addCache(api, CacheKey.FILES, map, executor);
        CurseCache.addCache(api, CacheKey.LATEST_FILE, map, executor);
        this.caches = Map.copyOf(map);
    }

    private static void addCache(CurseApi api, CacheKey<?, ?> key, Map<CacheKey<?, ?>, Cache<?, ?>> map, ScheduledExecutorService executor) {
        Cache cache = new Cache(api, key);
        map.put(key, cache);
        executor.scheduleWithFixedDelay(cache::clear, key.cacheTimeMillis, key.cacheTimeMillis, TimeUnit.MILLISECONDS);
    }

    public <K, V> V get(CacheKey<K, V> cache, K key, CacheFunction<K, V> value) throws IOException {
        return (V)this.caches.get(cache).get(key, value);
    }

    public <K, V> Optional<V> getCached(CacheKey<K, V> cache, K key) {
        return this.caches.get(cache).getCached(key);
    }

    public <K, V> void store(CacheKey<K, V> cache, K key, V value) {
        this.caches.get(cache).store(key, value);
    }

    public <T> T runLocked(CacheKey<?, ?> cache, Callable<T> action) {
        try {
            this.caches.get(cache).lock();
            T t = action.call();
            return t;
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception during locked cache action: " + cache, e);
        }
        finally {
            this.caches.get(cache).unlock();
        }
    }

    private static class Cache<K, V> {
        private final CurseApi api;
        private final CacheKey<K, V> key;
        private final Map<K, V> map;
        private int locked;
        private boolean shouldClearAfterLocked;

        private Cache(CurseApi api, CacheKey<K, V> key) {
            this.api = api;
            this.key = key;
            this.map = new HashMap();
            this.locked = 0;
            this.shouldClearAfterLocked = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key, CacheFunction<K, V> value) throws IOException {
            CacheKey<K, V> cacheKey = this.key;
            synchronized (cacheKey) {
                if (this.map.size() >= this.key.size && !this.map.containsKey(key)) {
                    this.clear();
                }
                if (!this.map.containsKey(key)) {
                    V result = value.apply(this.api, key);
                    this.map.put(key, result);
                    return result;
                }
                return this.map.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Optional<V> getCached(K key) {
            CacheKey<K, V> cacheKey = this.key;
            synchronized (cacheKey) {
                if (this.map.containsKey(key)) {
                    return Optional.of(this.map.get(key));
                }
                return Optional.empty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void store(K key, V value) {
            CacheKey<K, V> cacheKey = this.key;
            synchronized (cacheKey) {
                if (this.map.size() >= this.key.size && !this.map.containsKey(key)) {
                    this.clear();
                }
                this.map.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock() {
            CacheKey<K, V> cacheKey = this.key;
            synchronized (cacheKey) {
                ++this.locked;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock() {
            CacheKey<K, V> cacheKey = this.key;
            synchronized (cacheKey) {
                --this.locked;
                if (this.shouldClearAfterLocked && this.locked <= 0) {
                    this.shouldClearAfterLocked = false;
                    this.map.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            CacheKey<K, V> cacheKey = this.key;
            synchronized (cacheKey) {
                if (this.locked <= 0) {
                    this.map.clear();
                } else {
                    this.shouldClearAfterLocked = true;
                }
            }
        }
    }
}

