/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.cursewrapper.convert;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import org.moddingx.cursewrapper.api.response.ModLoader;
import org.moddingx.cursewrapper.backend.data.structure.ModLoaderType;

public class GameVersionProcessor {
    public static GameVersionData data(List<String> gameVersions) {
        HashSet<ModLoader> loaders = new HashSet<ModLoader>();
        HashSet<String> versions = new HashSet<String>();
        block19: for (String str : gameVersions) {
            switch (str.toLowerCase(Locale.ROOT)) {
                case "forge": 
                case "minecraftforge": 
                case "minecraft_forge": {
                    loaders.add(ModLoader.FORGE);
                    continue block19;
                }
                case "fabric": {
                    loaders.add(ModLoader.FABRIC);
                    continue block19;
                }
                case "rift": {
                    loaders.add(ModLoader.RIFT);
                    continue block19;
                }
                case "liteloader": 
                case "lite_loader": {
                    loaders.add(ModLoader.LITE_LOADER);
                    continue block19;
                }
                case "cauldron": {
                    loaders.add(ModLoader.CAULDRON);
                    continue block19;
                }
                case "quilt": {
                    loaders.add(ModLoader.QUILT);
                    continue block19;
                }
            }
            versions.add(str);
        }
        if (loaders.isEmpty()) {
            loaders.add(ModLoader.FORGE);
        }
        if (loaders.contains((Object)ModLoader.FABRIC)) {
            loaders.add(ModLoader.QUILT);
        }
        return new GameVersionData(loaders.stream().sorted().toList(), versions.stream().sorted().toList());
    }

    public static boolean check(List<String> gameVersions, @Nullable ModLoader loader, @Nullable String version) {
        GameVersionData data = GameVersionProcessor.data(gameVersions);
        return !(loader != null && !data.loader().contains((Object)loader) || version != null && !data.versions().contains(version));
    }

    public static Set<ModLoaderType> forLoader(ModLoader loader) {
        for (ModLoaderType type : ModLoaderType.values()) {
            if (type == ModLoaderType.OTHER || loader != type.loader) continue;
            if (type == ModLoaderType.QUILT) {
                return Set.of(ModLoaderType.FABRIC, ModLoaderType.QUILT);
            }
            return Set.of(type);
        }
        return Set.of();
    }

    public record GameVersionData(List<ModLoader> loader, List<String> versions) {
    }
}

