/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.cursewrapper.route;

import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.moddingx.cursewrapper.api.response.FileInfo;
import org.moddingx.cursewrapper.api.response.ProjectInfo;
import org.moddingx.cursewrapper.backend.CurseApi;
import org.moddingx.cursewrapper.backend.CurseData;
import org.moddingx.cursewrapper.backend.data.request.BulkFilesRequest;
import org.moddingx.cursewrapper.backend.data.request.BulkModsRequest;
import org.moddingx.cursewrapper.backend.data.response.BulkFilesResponse;
import org.moddingx.cursewrapper.backend.data.response.BulkModsResponse;
import org.moddingx.cursewrapper.backend.data.response.ModFileResponse;
import org.moddingx.cursewrapper.backend.data.response.ModResponse;
import org.moddingx.cursewrapper.cache.CacheKey;
import org.moddingx.cursewrapper.convert.ApiConverter;

public class CommonCacheResolvers {
    public static String slug(CurseApi api, int projectId) throws IOException {
        return api.request((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"mods/\u0001"}, (int)projectId)), ModResponse.class).data.slug;
    }

    public static ProjectInfo project(CurseApi api, int projectId) throws IOException {
        return ApiConverter.project(api.request((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"mods/\u0001"}, (int)projectId)), ModResponse.class).data);
    }

    public static FileInfo file(CurseApi api, CacheKey.FileKey key) throws IOException {
        return ApiConverter.file(api.request((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"mods/\u0001/files/\u0001"}, (int)key.projectId(), (int)key.fileId())), ModFileResponse.class).data);
    }

    public static Map<Integer, ProjectInfo> projects(CurseApi api, Set<Integer> projectIds) throws IOException {
        List<ModResponse.Mod> mods = api.request((String)"mods", (CurseData)new BulkModsRequest(List.copyOf(projectIds)), BulkModsResponse.class).data;
        HashMap<Integer, ProjectInfo> map = new HashMap<Integer, ProjectInfo>();
        for (ModResponse.Mod mod : mods) {
            map.put(mod.id, ApiConverter.project(mod));
        }
        return map;
    }

    public static Map<CacheKey.FileKey, FileInfo> files(CurseApi api, Set<CacheKey.FileKey> fileKeys) throws IOException {
        List<Integer> fileIds = fileKeys.stream().map(CacheKey.FileKey::fileId).toList();
        List<ModFileResponse.ModFile> files = api.request((String)"mods/files", (CurseData)new BulkFilesRequest(fileIds), BulkFilesResponse.class).data;
        HashMap<CacheKey.FileKey, FileInfo> map = new HashMap<CacheKey.FileKey, FileInfo>();
        for (ModFileResponse.ModFile file : files) {
            map.put(new CacheKey.FileKey(file.modId, file.id), ApiConverter.file(file));
        }
        return map;
    }
}

