/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.cursewrapper.route;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.Optional;
import org.moddingx.cursewrapper.api.CurseWrapperJson;
import org.moddingx.cursewrapper.api.response.FileInfo;
import org.moddingx.cursewrapper.api.response.ModLoader;
import org.moddingx.cursewrapper.backend.CurseApi;
import org.moddingx.cursewrapper.backend.data.response.ModFileResponse;
import org.moddingx.cursewrapper.backend.data.response.ModFilesResponse;
import org.moddingx.cursewrapper.cache.CacheKey;
import org.moddingx.cursewrapper.cache.CurseCache;
import org.moddingx.cursewrapper.convert.ApiConverter;
import org.moddingx.cursewrapper.convert.GameVersionProcessor;
import org.moddingx.cursewrapper.route.CommonCacheResolvers;
import org.moddingx.cursewrapper.route.base.CurseRoute;
import org.moddingx.cursewrapper.route.base.JsonRoute;
import spark.Request;
import spark.Response;
import spark.Service;

public class LatestFileRoute
extends JsonRoute {
    public LatestFileRoute(Service spark, CurseCache cache) {
        super(spark, cache);
    }

    @Override
    protected JsonElement apply(Request request, Response response, CurseRoute.RouteData route) throws IOException {
        Optional<ModLoader> loader = Optional.ofNullable(request.queryParams("loader")).map(ModLoader::get);
        Optional<String> version = Optional.ofNullable(request.queryParams("version"));
        CacheKey.FilesKey key = new CacheKey.FilesKey(this.integer(request, "projectId"), loader, version);
        return this.cache.runLocked(CacheKey.FILE, () -> {
            Optional fileId = this.cache.get(CacheKey.LATEST_FILE, key, this::resolve);
            if (fileId.isPresent()) {
                FileInfo file = this.cache.get(CacheKey.FILE, (CacheKey.FileKey)fileId.get(), CommonCacheResolvers::file);
                return CurseWrapperJson.toJson(file);
            }
            throw this.spark.halt(204);
        });
    }

    private Optional<CacheKey.FileKey> resolve(CurseApi api, CacheKey.FilesKey key) throws IOException {
        int currentIdx = 0;
        int max = 1;
        int counter = 0;
        while (currentIdx < max && counter < 31) {
            ArrayListMultimap params = ArrayListMultimap.create();
            params.put((Object)"index", (Object)Integer.toString(currentIdx));
            params.put((Object)"pageSize", (Object)Integer.toString(currentIdx == 0 ? 10 : 100));
            ModFilesResponse resp = api.request("mods/" + key.projectId() + "/files", (Multimap<String, String>)params, ModFilesResponse.class);
            currentIdx = resp.pagination.index + resp.pagination.resultCount;
            max = resp.pagination.totalCount;
            ++counter;
            for (ModFileResponse.ModFile file : resp.data) {
                if (!GameVersionProcessor.check(file.gameVersions, key.loader().orElse(null), key.version().orElse(null))) continue;
                CacheKey.FileKey fileKey = new CacheKey.FileKey(file.modId, file.id);
                this.cache.store(CacheKey.FILE, fileKey, ApiConverter.file(file));
                return Optional.of(fileKey);
            }
        }
        return Optional.empty();
    }
}

