/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.cursewrapper.route;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.moddingx.cursewrapper.api.CurseWrapperJson;
import org.moddingx.cursewrapper.api.response.ModLoader;
import org.moddingx.cursewrapper.api.response.ProjectInfo;
import org.moddingx.cursewrapper.backend.CurseApi;
import org.moddingx.cursewrapper.backend.data.response.ModResponse;
import org.moddingx.cursewrapper.backend.data.response.ModSearchResponse;
import org.moddingx.cursewrapper.backend.data.structure.ModLoaderType;
import org.moddingx.cursewrapper.backend.data.structure.ModSearchSortField;
import org.moddingx.cursewrapper.cache.CacheKey;
import org.moddingx.cursewrapper.cache.CacheUtils;
import org.moddingx.cursewrapper.cache.CurseCache;
import org.moddingx.cursewrapper.convert.ApiConverter;
import org.moddingx.cursewrapper.convert.GameVersionProcessor;
import org.moddingx.cursewrapper.route.CommonCacheResolvers;
import org.moddingx.cursewrapper.route.base.CurseRoute;
import org.moddingx.cursewrapper.route.base.JsonRoute;
import spark.Request;
import spark.Response;
import spark.Service;

public class SearchRoute
extends JsonRoute {
    public SearchRoute(Service spark, CurseCache cache) {
        super(spark, cache);
    }

    @Override
    protected JsonElement apply(Request request, Response response, CurseRoute.RouteData route) throws IOException {
        String query = request.queryParams("query");
        if (query == null) {
            query = "";
        }
        Optional<ModLoader> loader = Optional.ofNullable(request.queryParams("loader")).map(ModLoader::get);
        Optional<String> version = Optional.ofNullable(request.queryParams("version"));
        CacheKey.SearchKey key = new CacheKey.SearchKey(query, loader, version);
        return (JsonElement)this.cache.runLocked(CacheKey.PROJECT, () -> {
            List projectIds = this.cache.get(CacheKey.SEARCH, key, this::resolve);
            List<ProjectInfo> projects = CacheUtils.bulkMap(this.cache, CacheKey.PROJECT, projectIds, CommonCacheResolvers::project, CommonCacheResolvers::projects);
            JsonArray json = new JsonArray();
            for (ProjectInfo project : projects) {
                json.add(CurseWrapperJson.toJson(project));
            }
            return json;
        });
    }

    private List<Integer> resolve(CurseApi api, CacheKey.SearchKey key) throws IOException {
        int index = 0;
        ArrayList<Integer> projectIds = new ArrayList<Integer>();
        while (projectIds.size() < 30) {
            ResolveData data = this.resolvePartial(api, key, index, Math.max(30 - projectIds.size(), 0));
            projectIds.addAll(data.resolvedProjects());
            index = data.index();
            if (data.canContinue()) continue;
            break;
        }
        return projectIds;
    }

    private ResolveData resolvePartial(CurseApi api, CacheKey.SearchKey key, int current, int left) throws IOException {
        Set<ModLoaderType> loaders = key.loader().isPresent() ? GameVersionProcessor.forLoader(key.loader().get()) : Set.of();
        boolean needsManualLoaderFiltering = loaders.size() > 1 || loaders.size() == 1 && key.version().isEmpty();
        ArrayListMultimap params = ArrayListMultimap.create();
        params.put((Object)"gameId", (Object)Integer.toString(432));
        params.put((Object)"classId", (Object)Integer.toString(6));
        params.put((Object)"index", (Object)Integer.toString(current));
        params.put((Object)"pageSize", (Object)Integer.toString(Math.round((float)left * 1.6f)));
        params.put((Object)"searchFilter", (Object)key.query());
        params.put((Object)"sortField", (Object)Integer.toString(ModSearchSortField.POPULARITY.ordinal()));
        params.put((Object)"sortOrder", (Object)"desc");
        if (key.version().isPresent()) {
            params.put((Object)"gameVersion", (Object)key.version().get());
        }
        if (loaders.size() == 1 && !needsManualLoaderFiltering) {
            params.put((Object)"modLoaderType", (Object)Integer.toString(((ModLoaderType)loaders.iterator().next()).ordinal()));
        }
        ModSearchResponse resp = api.request("mods/search", (Multimap<String, String>)params, ModSearchResponse.class);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (ModResponse.Mod mod : resp.data) {
            if (ids.size() >= left) break;
            if (needsManualLoaderFiltering && !this.checkLoader(mod, key.version().orElse(null), loaders)) continue;
            ids.add(mod.id);
            this.cache.store(CacheKey.PROJECT, mod.id, ApiConverter.project(mod));
        }
        return new ResolveData(current + Math.max(0, resp.pagination.resultCount), !resp.data.isEmpty() && resp.pagination.totalCount < resp.pagination.index + resp.pagination.resultCount, List.copyOf(ids));
    }

    private boolean checkLoader(ModResponse.Mod mod, @Nullable String gameVersion, Set<ModLoaderType> loaders) {
        return mod.latestFilesIndexes.stream().filter(file -> gameVersion == null || gameVersion.equals(file.gameVersion)).anyMatch(file -> loaders.contains(file.modLoader));
    }

    private record ResolveData(int index, boolean canContinue, List<Integer> resolvedProjects) {
    }
}

