/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.cursewrapper.route.base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.function.Function;
import org.moddingx.cursewrapper.cache.CurseCache;
import org.moddingx.cursewrapper.route.base.CurseRoute;
import spark.Request;
import spark.Response;
import spark.Service;

public abstract class JsonRoute
extends CurseRoute<JsonElement> {
    private static final Gson GSON;

    protected JsonRoute(Service spark, CurseCache cache) {
        super(spark, cache, "application/json", arg_0 -> ((Gson)GSON).toJson(arg_0));
    }

    @Override
    protected abstract JsonElement apply(Request var1, Response var2, CurseRoute.RouteData var3) throws IOException;

    protected final JsonElement body(Request request) {
        return (JsonElement)this.body(request, Function.identity());
    }

    protected final <T> T body(Request request, Function<JsonElement, T> mapper) {
        JsonElement data;
        String body = request.body();
        if (body == null || body.isEmpty()) {
            throw this.spark.halt(400, "Missing request content");
        }
        try {
            data = (JsonElement)GSON.fromJson(body, JsonElement.class);
        }
        catch (JsonSyntaxException e) {
            throw this.spark.halt(400, "Invalid json: " + e.getMessage());
        }
        try {
            return mapper.apply(data);
        }
        catch (Exception e) {
            throw this.spark.halt(400, "Invalid request content.");
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        GSON = builder.create();
    }
}

