/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.launcher;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.moddingx.launcherlib.launcher.cache.LauncherCache;

public class AssetIndex {
    private final LauncherCache cache;
    private final Map<String, String> objects;

    public AssetIndex(LauncherCache cache, JsonObject json) {
        this.cache = cache;
        HashMap<String, String> objects = new HashMap<String, String>();
        for (Map.Entry entry : json.getAsJsonObject("objects").entrySet()) {
            String key = (String)entry.getKey();
            while (key.startsWith("/")) {
                key = key.substring(1);
            }
            String hash = ((JsonElement)entry.getValue()).getAsJsonObject().get("hash").getAsString();
            objects.put(key, hash);
        }
        this.objects = Map.copyOf(objects);
    }

    public void download(Path path) {
        int threads = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(threads);
        ArrayList futures = new ArrayList(this.objects.size());
        for (Map.Entry<String, String> entry : this.objects.entrySet()) {
            futures.add(executor.submit(() -> {
                try {
                    Path target = path.resolve(((String)entry.getKey()).replace("/", path.getFileSystem().getSeparator()));
                    if (!Files.exists(target.getParent(), new LinkOption[0])) {
                        Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    }
                    URL url = new URL("https://resources.download.minecraft.net/" + ((String)entry.getValue()).substring(0, 2) + "/" + (String)entry.getValue());
                    try (InputStream in = this.cache.downloadAsset((String)entry.getValue(), url);){
                        Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to download " + (String)entry.getKey(), e);
                }
            }));
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to download assets", e);
        }
        finally {
            try {
                executor.shutdownNow();
            }
            catch (Exception exception) {}
        }
    }
}

