/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.launcher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.WillClose;
import org.moddingx.launcherlib.launcher.VersionInfo;
import org.moddingx.launcherlib.launcher.cache.LauncherCache;
import org.moddingx.launcherlib.launcher.cache.NoCache;
import org.moddingx.launcherlib.launcher.cache.PathCache;
import org.moddingx.launcherlib.util.IoFunction;
import org.moddingx.launcherlib.util.LazyValue;

public class Launcher {
    private static final String MANIFEST = "https://piston-meta.mojang.com/mc/game/version_manifest_v2.json";
    private static final Gson GSON;
    private final LauncherCache cache;
    private String latestRelease = null;
    private String latestSnapshot = null;
    private List<String> versions = null;
    private Map<String, LazyValue<VersionInfo>> versionInfo = null;

    public Launcher() {
        this(NoCache.INSTANCE);
    }

    public Launcher(Path cachePath) {
        this(new PathCache(cachePath));
    }

    public Launcher(LauncherCache cache) {
        this.cache = cache;
    }

    private synchronized void initIfNeeded() {
        try {
            if (this.latestRelease == null || this.latestSnapshot == null || this.versions == null || this.versionInfo == null) {
                JsonObject json = Launcher.make(new URL(MANIFEST), (JsonObject j) -> j);
                JsonObject latest = json.getAsJsonObject("latest");
                this.latestRelease = latest.get("release").getAsString();
                this.latestSnapshot = latest.get("snapshot").getAsString();
                ArrayList<String> list = new ArrayList<String>();
                HashMap<String, LazyValue<VersionInfo>> table = new HashMap<String, LazyValue<VersionInfo>>();
                for (JsonElement entry : json.getAsJsonArray("versions")) {
                    String key = entry.getAsJsonObject().get("id").getAsString();
                    URL url = new URL(entry.getAsJsonObject().get("url").getAsString());
                    list.add(key);
                    table.put(key, new LazyValue<VersionInfo>(() -> Launcher.make(url, (JsonObject j) -> new VersionInfo(this.cache, (JsonObject)j, key))));
                }
                Collections.reverse(list);
                this.versions = List.copyOf(list);
                this.versionInfo = Map.copyOf(table);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String latestRelease() {
        this.initIfNeeded();
        return this.latestRelease;
    }

    public String latestSnapshot() {
        this.initIfNeeded();
        return this.latestSnapshot;
    }

    public synchronized List<String> versions() {
        this.initIfNeeded();
        return this.versions;
    }

    public synchronized VersionInfo version(String id) {
        this.initIfNeeded();
        if (!this.versionInfo.containsKey(id)) {
            throw new NoSuchElementException("Unknown version: " + id);
        }
        return this.versionInfo.get(id).get();
    }

    public static <T> T make(URL url, IoFunction<JsonObject, T> factory) {
        try {
            return Launcher.make(url.openStream(), factory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T make(@WillClose InputStream in, IoFunction<JsonObject, T> factory) {
        try (InputStream inStream = in;){
            JsonObject jsonObject;
            try (InputStreamReader reader = new InputStreamReader(inStream);){
                jsonObject = factory.apply((JsonObject)GSON.fromJson((Reader)reader, JsonObject.class));
            }
            return (T)jsonObject;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        GSON = builder.create();
    }
}

