/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.moddingx.launcherlib.launcher.cache.LauncherCache;

public class Library {
    private final LauncherCache cache;
    private final String key;
    private final String path;
    private final URL url;
    @Nullable
    private final Set<String> os;

    public Library(LauncherCache cache, String key, String path, URL url, @Nullable Set<String> os) {
        this.cache = cache;
        this.key = key;
        this.path = path;
        this.url = url;
        this.os = os == null ? null : os.stream().map(str -> str.toLowerCase(Locale.ROOT)).collect(Collectors.toUnmodifiableSet());
    }

    public String key() {
        return this.key;
    }

    public String path() {
        return this.path;
    }

    public boolean shouldDownloadOn(String os) {
        return this.os == null || this.os.contains(os.toLowerCase(Locale.ROOT));
    }

    public InputStream openStream() throws IOException {
        return this.cache.downloadLibrary(this.key, this.url);
    }

    public void download(Path basePath) throws IOException {
        Path target = basePath.resolve(this.path.replace("/", basePath.getFileSystem().getSeparator()));
        if (!Files.exists(target.getParent(), new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        try (InputStream in = this.openStream();){
            Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

