/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.launcher;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import net.minecraftforge.srgutils.IMappingFile;
import org.moddingx.launcherlib.launcher.AssetIndex;
import org.moddingx.launcherlib.launcher.Launcher;
import org.moddingx.launcherlib.launcher.Library;
import org.moddingx.launcherlib.launcher.VersionType;
import org.moddingx.launcherlib.launcher.cache.LauncherCache;
import org.moddingx.launcherlib.mappings.MappingHelper;
import org.moddingx.launcherlib.util.LazyValue;

public class VersionInfo {
    private final LauncherCache cache;
    private final String id;
    private final VersionType type;
    private final Instant releaseTime;
    private final int java;
    private final URL client;
    @Nullable
    private final URL server;
    private final List<Library> libraries;
    private final LazyValue<AssetIndex> assets;
    @Nullable
    private final LazyValue<IMappingFile> clientMap;
    @Nullable
    private final LazyValue<IMappingFile> serverMap;
    @Nullable
    private final LazyValue<IMappingFile> mergedMap;
    private static final Map<String, Integer> MANUAL_JAVA_MAP;

    public VersionInfo(LauncherCache cache, JsonObject json, String id) throws IOException {
        try {
            this.cache = cache;
            this.id = id;
            this.type = VersionType.get(json.get("type").getAsString());
            this.releaseTime = Instant.from(DateTimeFormatter.ISO_DATE_TIME.parse(json.get("releaseTime").getAsString()));
            this.java = MANUAL_JAVA_MAP.containsKey(id) ? MANUAL_JAVA_MAP.get(id).intValue() : json.getAsJsonObject("javaVersion").get("majorVersion").getAsInt();
            URL assetURL = new URL(json.getAsJsonObject("assetIndex").get("url").getAsString());
            this.assets = new LazyValue<AssetIndex>(() -> Launcher.make(assetURL, j -> new AssetIndex(cache, (JsonObject)j)));
            JsonObject downloads = json.getAsJsonObject("downloads");
            this.client = new URL(downloads.getAsJsonObject("client").get("url").getAsString());
            this.server = downloads.has("server") ? new URL(downloads.getAsJsonObject("server").get("url").getAsString()) : null;
            if (downloads.has("client_mappings") && downloads.has("server_mappings")) {
                URL clientMapUrl = new URL(downloads.getAsJsonObject("client_mappings").get("url").getAsString());
                this.clientMap = new LazyValue<IMappingFile>(() -> this.loadMappings("client", clientMapUrl));
                URL serverMapUrl = new URL(downloads.getAsJsonObject("server_mappings").get("url").getAsString());
                this.serverMap = new LazyValue<IMappingFile>(() -> this.loadMappings("server", serverMapUrl));
                this.mergedMap = new LazyValue<IMappingFile>(() -> MappingHelper.merge(this.clientMap.get(), this.serverMap.get()));
            } else {
                this.clientMap = null;
                this.serverMap = null;
                this.mergedMap = null;
            }
            ArrayList<Library> libraries = new ArrayList<Library>();
            for (JsonElement lib : json.getAsJsonArray("libraries")) {
                JsonArray rules;
                JsonObject download = lib.getAsJsonObject();
                HashSet<String> os = null;
                if (download.has("rules") && !(rules = download.getAsJsonArray("rules")).isEmpty()) {
                    os = new HashSet<String>();
                    for (JsonElement ruleElem : rules) {
                        JsonObject rule = ruleElem.getAsJsonObject();
                        if (!rule.has("os") || !rule.getAsJsonObject("os").has("name") || !"allow".equals(rule.get("action").getAsString())) continue;
                        os.add(rule.getAsJsonObject("os").get("name").getAsString());
                    }
                }
                String key = download.get("name").getAsString();
                if (download.getAsJsonObject("downloads").has("classifiers")) continue;
                String path = download.getAsJsonObject("downloads").getAsJsonObject("artifact").get("path").getAsString();
                URL url = new URL(download.getAsJsonObject("downloads").getAsJsonObject("artifact").get("url").getAsString());
                libraries.add(new Library(this.cache, key, path, url, os));
            }
            this.libraries = List.copyOf(libraries);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to parse version information for " + id, e);
        }
    }

    private IMappingFile loadMappings(String key, URL url) {
        IMappingFile iMappingFile;
        block8: {
            InputStream in = this.cache.downloadMappings(this.id, key, url);
            try {
                IMappingFile mappings = IMappingFile.load((InputStream)in);
                iMappingFile = mappings.reverse();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return iMappingFile;
    }

    public String id() {
        return this.id;
    }

    public VersionType type() {
        return this.type;
    }

    public Instant releaseTime() {
        return this.releaseTime;
    }

    public int java() {
        return this.java;
    }

    public InputStream client() throws IOException {
        return this.cache.downloadVersion(this.id, "client", this.client);
    }

    public InputStream server() throws IOException {
        if (this.server == null) {
            throw new NoSuchElementException("No server available for version " + this.id);
        }
        return this.cache.downloadVersion(this.id, "server", this.server);
    }

    public List<Library> libraries() {
        return this.libraries;
    }

    public AssetIndex assets() {
        return this.assets.get();
    }

    public IMappingFile clientMap() {
        if (this.clientMap == null) {
            throw new NoSuchElementException("No mappings available for version " + this.id);
        }
        return this.clientMap.get();
    }

    public IMappingFile serverMap() {
        if (this.serverMap == null) {
            throw new NoSuchElementException("No mappings available for version " + this.id);
        }
        return this.serverMap.get();
    }

    public IMappingFile mergedMap() {
        if (this.mergedMap == null) {
            throw new NoSuchElementException("No mappings available for version " + this.id);
        }
        return this.mergedMap.get();
    }

    static {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("13w24a", 8);
        map.put("13w24b", 8);
        map.put("13w25a", 8);
        map.put("13w25b", 8);
        map.put("13w25c", 8);
        map.put("13w26a", 8);
        map.put("1.6", 8);
        map.put("1.6.1", 8);
        map.put("1.6.2", 8);
        map.put("13w36a", 8);
        map.put("13w36b", 8);
        map.put("13w37a", 8);
        map.put("1.6.3", 8);
        map.put("13w37b", 8);
        map.put("1.6.4", 8);
        map.put("13w38a", 8);
        map.put("13w38b", 8);
        map.put("13w38c", 8);
        MANUAL_JAVA_MAP = Map.copyOf(map);
    }
}

