/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.launcher.cache;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.moddingx.launcherlib.launcher.cache.LauncherCache;

public class PathCache
implements LauncherCache {
    private final Path base;

    public PathCache(Path base) {
        this.base = base;
    }

    @Override
    public InputStream downloadVersion(String version, String key, URL url) throws IOException {
        return this.downloadIfNeeded(this.base.resolve("versions").resolve(version).resolve(key + ".jar"), url);
    }

    @Override
    public InputStream downloadMappings(String version, String key, URL url) throws IOException {
        return this.downloadIfNeeded(this.base.resolve("versions").resolve(version).resolve(key + ".pg"), url);
    }

    @Override
    public InputStream downloadLibrary(String key, URL url) throws IOException {
        return this.downloadIfNeeded(this.base.resolve("libraries").resolve(key.replace(":", this.base.getFileSystem().getSeparator()) + ".jar"), url);
    }

    @Override
    public InputStream downloadAsset(String hash, URL url) throws IOException {
        return this.downloadIfNeeded(this.base.resolve("assets").resolve(hash.substring(0, 2)).resolve(hash), url);
    }

    private InputStream downloadIfNeeded(Path path, URL url) throws IOException {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            this.createParents(path);
            try (InputStream in = url.openStream();){
                Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return Files.newInputStream(path, new OpenOption[0]);
    }

    private void createParents(Path path) throws IOException {
        Path parent = path.toAbsolutePath().getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }
}

