/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.mappings;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.srgutils.IMappingBuilder;
import net.minecraftforge.srgutils.IMappingFile;
import org.moddingx.launcherlib.mappings.MappingWriter;
import org.moddingx.launcherlib.mappings.visitor.ClassMappingVisitor;
import org.moddingx.launcherlib.mappings.visitor.FieldMappingVisitor;
import org.moddingx.launcherlib.mappings.visitor.MappingVisitor;
import org.moddingx.launcherlib.mappings.visitor.MethodMappingVisitor;
import org.moddingx.launcherlib.mappings.visitor.PackageMappingVisitor;
import org.moddingx.launcherlib.mappings.visitor.ParameterMappingVisitor;

public class MappingHelper {
    public static void accept(IMappingFile mappings, MappingVisitor visitor) {
        for (IMappingFile.IPackage pkg : mappings.getPackages()) {
            PackageMappingVisitor pkgVisitor = visitor.visitPackage(pkg.getOriginal(), pkg.getMapped());
            if (pkgVisitor == null) continue;
            for (Map.Entry entry : pkg.getMetadata().entrySet()) {
                pkgVisitor.visitMeta((String)entry.getKey(), (String)entry.getValue());
            }
            pkgVisitor.visitEnd();
        }
        for (IMappingFile.IClass cls : mappings.getClasses()) {
            ClassMappingVisitor clsVisitor = visitor.visitClass(cls.getOriginal(), cls.getMapped());
            if (clsVisitor == null) continue;
            for (IMappingFile.IField fd : cls.getFields()) {
                FieldMappingVisitor fdVisitor = clsVisitor.visitField(fd.getDescriptor(), fd.getOriginal(), fd.getMapped());
                if (fdVisitor == null) continue;
                for (Map.Entry entry : fd.getMetadata().entrySet()) {
                    fdVisitor.visitMeta((String)entry.getKey(), (String)entry.getValue());
                }
            }
            for (IMappingFile.IMethod md : cls.getMethods()) {
                MethodMappingVisitor mdVisitor = clsVisitor.visitMethod(md.getDescriptor(), md.getOriginal(), md.getMapped());
                if (mdVisitor == null) continue;
                for (IMappingFile.IParameter param : md.getParameters()) {
                    ParameterMappingVisitor paramVisitor = mdVisitor.visitParameter(param.getIndex(), param.getOriginal(), param.getMapped());
                    if (paramVisitor == null) continue;
                    for (Map.Entry entry : param.getMetadata().entrySet()) {
                        paramVisitor.visitMeta((String)entry.getKey(), (String)entry.getValue());
                    }
                    paramVisitor.visitEnd();
                }
                for (Map.Entry entry : md.getMetadata().entrySet()) {
                    mdVisitor.visitMeta((String)entry.getKey(), (String)entry.getValue());
                }
                mdVisitor.visitEnd();
            }
            for (Map.Entry entry : cls.getMetadata().entrySet()) {
                clsVisitor.visitMeta((String)entry.getKey(), (String)entry.getValue());
            }
            clsVisitor.visitEnd();
        }
        visitor.visitEnd();
    }

    public static IMappingFile merge(IMappingFile ... mappings) {
        return MappingHelper.merge(Arrays.asList(mappings));
    }

    public static IMappingFile merge(List<IMappingFile> mappings) {
        if (mappings.size() == 0) {
            return IMappingBuilder.create((String[])new String[]{"left", "right"}).build().getMap("left", "right");
        }
        if (mappings.size() == 1) {
            return mappings.get(0);
        }
        MappingWriter writer = new MappingWriter();
        for (IMappingFile mapping : mappings) {
            MappingHelper.accept(mapping, writer);
        }
        return writer.result();
    }

    public static IMappingFile removeParameters(IMappingFile mappings) {
        MappingWriter writer = new MappingWriter();
        MappingHelper.accept(mappings, new MappingVisitor(writer){

            @Override
            public ClassMappingVisitor visitClass(String original, String mapped) {
                return new ClassMappingVisitor(super.visitClass(original, mapped)){

                    @Override
                    public MethodMappingVisitor visitMethod(String descriptor, String original, String mapped) {
                        return new MethodMappingVisitor(super.visitMethod(descriptor, original, mapped)){

                            @Override
                            @Nullable
                            public ParameterMappingVisitor visitParameter(int idx, String original, String mapped) {
                                return null;
                            }
                        };
                    }
                };
            }
        });
        return writer.result();
    }

    public static IMappingFile removeMeta(IMappingFile mappings) {
        MappingWriter writer = new MappingWriter();
        MappingHelper.accept(mappings, new MappingVisitor(writer){

            @Override
            public PackageMappingVisitor visitPackage(String original, String mapped) {
                return new PackageMappingVisitor(super.visitPackage(original, mapped)){

                    @Override
                    public void visitMeta(String key, String value) {
                    }
                };
            }

            @Override
            public ClassMappingVisitor visitClass(String original, String mapped) {
                return new ClassMappingVisitor(super.visitClass(original, mapped)){

                    @Override
                    public FieldMappingVisitor visitField(@Nullable String descriptor, String original, String mapped) {
                        return new FieldMappingVisitor(super.visitField(descriptor, original, mapped)){

                            @Override
                            public void visitMeta(String key, String value) {
                            }
                        };
                    }

                    @Override
                    public MethodMappingVisitor visitMethod(String descriptor, String original, String mapped) {
                        return new MethodMappingVisitor(super.visitMethod(descriptor, original, mapped)){

                            @Override
                            public ParameterMappingVisitor visitParameter(int idx, String original, String mapped) {
                                return new ParameterMappingVisitor(super.visitParameter(idx, original, mapped)){

                                    @Override
                                    public void visitMeta(String key, String value) {
                                    }
                                };
                            }

                            @Override
                            public void visitMeta(String key, String value) {
                            }
                        };
                    }

                    @Override
                    public void visitMeta(String key, String value) {
                    }
                };
            }
        });
        return writer.result();
    }
}

