/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.mappings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.srgutils.IMappingBuilder;
import net.minecraftforge.srgutils.IMappingFile;
import org.moddingx.launcherlib.mappings.visitor.ClassMappingVisitor;
import org.moddingx.launcherlib.mappings.visitor.FieldMappingVisitor;
import org.moddingx.launcherlib.mappings.visitor.MappingVisitor;
import org.moddingx.launcherlib.mappings.visitor.MethodMappingVisitor;
import org.moddingx.launcherlib.mappings.visitor.PackageMappingVisitor;
import org.moddingx.launcherlib.mappings.visitor.ParameterMappingVisitor;

public class MappingWriter
extends MappingVisitor {
    private final IMappingBuilder builder = IMappingBuilder.create((String[])new String[]{"left", "right"});
    private final Map<String, PackageVisitor> packages = new HashMap<String, PackageVisitor>();
    private final Map<String, ClassVisitor> classes = new HashMap<String, ClassVisitor>();
    @Nullable
    private IMappingFile result = null;

    private void ensureMutable() {
        if (this.result != null) {
            throw new IllegalStateException("MappingWriter#result() has already been called.");
        }
    }

    @Override
    @Nullable
    public PackageMappingVisitor visitPackage(String original, String mapped) {
        this.ensureMutable();
        return this.packages.computeIfAbsent(original, k -> new PackageVisitor(this.builder.addPackage(new String[]{original, mapped})));
    }

    @Override
    @Nullable
    public ClassMappingVisitor visitClass(String original, String mapped) {
        this.ensureMutable();
        return this.classes.computeIfAbsent(original, k -> new ClassVisitor(this.builder.addClass(new String[]{original, mapped})));
    }

    @Override
    public void visitEnd() {
        this.ensureMutable();
    }

    public IMappingFile result() {
        if (this.result == null) {
            this.result = this.builder.build().getMap("left", "right");
        }
        return this.result;
    }

    private class ClassVisitor
    extends ClassMappingVisitor {
        private final IMappingBuilder.IClass cls;
        private final Map<String, FieldVisitor> fields;
        private final Map<MethodKey, MethodVisitor> methods;
        private final Set<String> metaKeys;

        public ClassVisitor(IMappingBuilder.IClass cls) {
            this.cls = cls;
            this.fields = new HashMap<String, FieldVisitor>();
            this.methods = new HashMap<MethodKey, MethodVisitor>();
            this.metaKeys = new HashSet<String>();
        }

        @Override
        @Nullable
        public FieldMappingVisitor visitField(@Nullable String descriptor, String original, String mapped) {
            MappingWriter.this.ensureMutable();
            FieldVisitor fv = this.fields.computeIfAbsent(original, k -> {
                IMappingBuilder.IField fd = this.cls.field(new String[]{original, mapped});
                return new FieldVisitor(fd, mapped);
            });
            if (!fv.hasDescriptor && Objects.equals(mapped, fv.mapped)) {
                fv.fd.descriptor(descriptor);
                fv.hasDescriptor = true;
            }
            return fv;
        }

        @Override
        @Nullable
        public MethodMappingVisitor visitMethod(String descriptor, String original, String mapped) {
            MappingWriter.this.ensureMutable();
            return this.methods.computeIfAbsent(new MethodKey(original, descriptor), k -> new MethodVisitor(this.cls.method(descriptor, new String[]{original, mapped})));
        }

        @Override
        public void visitMeta(String key, String value) {
            MappingWriter.this.ensureMutable();
            if (this.metaKeys.add(key)) {
                this.cls.meta(key, value);
            }
        }

        @Override
        public void visitEnd() {
            MappingWriter.this.ensureMutable();
        }
    }

    private class PackageVisitor
    extends PackageMappingVisitor {
        private final IMappingBuilder.IPackage pkg;
        private final Set<String> metaKeys;

        public PackageVisitor(IMappingBuilder.IPackage pkg) {
            this.pkg = pkg;
            this.metaKeys = new HashSet<String>();
        }

        @Override
        public void visitMeta(String key, String value) {
            MappingWriter.this.ensureMutable();
            if (this.metaKeys.add(key)) {
                this.pkg.meta(key, value);
            }
        }

        @Override
        public void visitEnd() {
            MappingWriter.this.ensureMutable();
        }
    }

    private record MethodKey(String name, String descriptor) {
    }

    private class ParameterVisitor
    extends ParameterMappingVisitor {
        private final IMappingBuilder.IParameter param;
        private final Set<String> metaKeys;

        private ParameterVisitor(IMappingBuilder.IParameter param) {
            this.param = param;
            this.metaKeys = new HashSet<String>();
        }

        @Override
        public void visitMeta(String key, String value) {
            MappingWriter.this.ensureMutable();
            if (this.metaKeys.add(key)) {
                this.param.meta(key, value);
            }
        }

        @Override
        public void visitEnd() {
            MappingWriter.this.ensureMutable();
        }
    }

    private class MethodVisitor
    extends MethodMappingVisitor {
        private final IMappingBuilder.IMethod md;
        private final Map<Integer, ParameterVisitor> parameters;
        private final Set<String> metaKeys;

        private MethodVisitor(IMappingBuilder.IMethod md) {
            this.md = md;
            this.parameters = new HashMap<Integer, ParameterVisitor>();
            this.metaKeys = new HashSet<String>();
        }

        @Override
        @Nullable
        public ParameterMappingVisitor visitParameter(int idx, String original, String mapped) {
            MappingWriter.this.ensureMutable();
            return this.parameters.computeIfAbsent(idx, k -> new ParameterVisitor(this.md.parameter(idx, new String[]{original, mapped})));
        }

        @Override
        public void visitMeta(String key, String value) {
            MappingWriter.this.ensureMutable();
            if (this.metaKeys.add(key)) {
                this.md.meta(key, value);
            }
        }

        @Override
        public void visitEnd() {
            MappingWriter.this.ensureMutable();
        }
    }

    private class FieldVisitor
    extends FieldMappingVisitor {
        private final IMappingBuilder.IField fd;
        private final String mapped;
        private boolean hasDescriptor;
        private final Set<String> metaKeys;

        private FieldVisitor(IMappingBuilder.IField fd, String mapped) {
            this.fd = fd;
            this.mapped = mapped;
            this.hasDescriptor = false;
            this.metaKeys = new HashSet<String>();
        }

        @Override
        public void visitMeta(String key, String value) {
            MappingWriter.this.ensureMutable();
            if (this.metaKeys.add(key)) {
                this.fd.meta(key, value);
            }
        }

        @Override
        public void visitEnd() {
            MappingWriter.this.ensureMutable();
        }
    }
}

