/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.nbt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.DeflaterInputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.WillClose;
import org.moddingx.launcherlib.nbt.InvalidNbtException;
import org.moddingx.launcherlib.nbt.TagType;
import org.moddingx.launcherlib.nbt.tag.ByteArrayTag;
import org.moddingx.launcherlib.nbt.tag.CompoundTag;
import org.moddingx.launcherlib.nbt.tag.IntArrayTag;
import org.moddingx.launcherlib.nbt.tag.ListTag;
import org.moddingx.launcherlib.nbt.tag.LongArrayTag;
import org.moddingx.launcherlib.nbt.tag.NumberTag;
import org.moddingx.launcherlib.nbt.tag.StringTag;
import org.moddingx.launcherlib.nbt.tag.Tag;

public class NBT {
    public static Tag read(@WillClose InputStream in) throws IOException {
        return NBT.read(in, Compression.GZIP);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Tag read(@WillClose InputStream in, Compression compression) throws IOException {
        try (InputStream inputStream = in;){
            Tag tag;
            block21: {
                DataInputStream input = switch (compression) {
                    default -> throw new IncompatibleClassChangeError();
                    case Compression.NONE -> {
                        if (in instanceof DataInputStream) {
                            DataInputStream di;
                            yield di = (DataInputStream)in;
                        }
                        if (in instanceof BufferedInputStream) {
                            yield new DataInputStream(in);
                        }
                        yield new DataInputStream(new BufferedInputStream(in));
                    }
                    case Compression.GZIP -> new DataInputStream(new BufferedInputStream(new GZIPInputStream(in)));
                    case Compression.DEFLATE -> new DataInputStream(new BufferedInputStream(new DeflaterInputStream(in)));
                };
                try {
                    tag = NBT.readCompound(input, true);
                    if (input == null) break block21;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input.close();
            }
            return tag;
        }
        catch (EOFException e) {
            throw new InvalidNbtException("End of stream", e);
        }
    }

    public static void write(Tag tag, @WillClose OutputStream out) throws IOException {
        NBT.write(tag, out, Compression.GZIP);
    }

    public static void write(Tag tag, @WillClose OutputStream out, Compression compression) throws IOException {
        try (OutputStream outputStream = out;){
            DataOutputStream dataOutputStream = switch (compression) {
                default -> throw new IncompatibleClassChangeError();
                case Compression.NONE -> {
                    if (out instanceof DataOutputStream) {
                        DataOutputStream dd;
                        yield dd = (DataOutputStream)out;
                    }
                    if (out instanceof BufferedOutputStream) {
                        yield new DataOutputStream(out);
                    }
                    yield new DataOutputStream(new BufferedOutputStream(out));
                }
                case Compression.GZIP -> new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(out)));
                case Compression.DEFLATE -> new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream(out)));
            };
            try (DataOutputStream output = dataOutputStream;){
                output.writeByte(tag.type().id());
                output.writeUTF("");
                NBT.writeTag(tag, output);
            }
        }
    }

    private static Tag readTag(TagType type, DataInput input) throws IOException {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TagType.END -> throw new InvalidNbtException("No tag to end.");
            case TagType.BYTE -> NumberTag.createByte(input.readByte());
            case TagType.SHORT -> NumberTag.createShort(input.readShort());
            case TagType.INT -> NumberTag.createInt(input.readInt());
            case TagType.LONG -> NumberTag.createLong(input.readLong());
            case TagType.FLOAT -> NumberTag.createFloat(input.readFloat());
            case TagType.DOUBLE -> NumberTag.createDouble(input.readDouble());
            case TagType.STRING -> new StringTag(input.readUTF());
            case TagType.BYTE_ARRAY -> {
                int len = input.readInt();
                byte[] data = new byte[len];
                input.readFully(data);
                yield new ByteArrayTag(data);
            }
            case TagType.INT_ARRAY -> {
                int len = input.readInt();
                int[] data = new int[len];
                for (int i = 0; i < len; ++i) {
                    data[i] = input.readInt();
                }
                yield new IntArrayTag(data);
            }
            case TagType.LONG_ARRAY -> {
                int len = input.readInt();
                long[] data = new long[len];
                for (int i = 0; i < len; ++i) {
                    data[i] = input.readLong();
                }
                yield new LongArrayTag(data);
            }
            case TagType.LIST -> {
                TagType elementType = TagType.get(input.readByte());
                int len = input.readInt();
                ArrayList<Tag> elements = new ArrayList<Tag>(len);
                for (int i = 0; i < len; ++i) {
                    elements.add(NBT.readTag(elementType, input));
                }
                yield new ListTag(elements);
            }
            case TagType.COMPOUND -> NBT.readCompound(input, false);
        };
    }

    private static Tag readCompound(DataInput input, boolean single) throws IOException {
        HashMap<String, Tag> tags = new HashMap<String, Tag>();
        TagType type;
        while ((type = TagType.get(input.readByte())) != TagType.END) {
            String key = input.readUTF();
            Tag value = NBT.readTag(type, input);
            if (single) {
                if ("".equals(key)) {
                    return value;
                }
                tags.put(key, value);
                return new CompoundTag(tags);
            }
            tags.put(key, value);
        }
        return new CompoundTag(tags);
    }

    private static void writeTag(Tag tag, DataOutput output) throws IOException {
        switch (tag.type()) {
            case BYTE: {
                output.writeByte(((NumberTag)tag).asByte());
                break;
            }
            case SHORT: {
                output.writeShort(((NumberTag)tag).asShort());
                break;
            }
            case INT: {
                output.writeInt(((NumberTag)tag).asInt());
                break;
            }
            case LONG: {
                output.writeLong(((NumberTag)tag).asLong());
                break;
            }
            case FLOAT: {
                output.writeFloat(((NumberTag)tag).asFloat());
                break;
            }
            case DOUBLE: {
                output.writeDouble(((NumberTag)tag).asDouble());
                break;
            }
            case STRING: {
                output.writeUTF(((StringTag)tag).value());
                break;
            }
            case BYTE_ARRAY: {
                ByteArrayTag bt = (ByteArrayTag)tag;
                output.writeInt(bt.size());
                Iterator iterator = bt.iterator();
                while (iterator.hasNext()) {
                    byte b = (Byte)iterator.next();
                    output.writeByte(b);
                }
                break;
            }
            case INT_ARRAY: {
                IntArrayTag it = (IntArrayTag)tag;
                output.writeInt(it.size());
                Iterator iterator = it.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    output.writeInt(i);
                }
                break;
            }
            case LONG_ARRAY: {
                LongArrayTag lt = (LongArrayTag)tag;
                output.writeInt(lt.size());
                Iterator iterator = lt.iterator();
                while (iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    output.writeLong(l);
                }
                break;
            }
            case LIST: {
                ListTag lt = (ListTag)tag;
                TagType elementType = lt.elementType();
                output.writeByte(elementType.id());
                output.writeInt(lt.size());
                for (Tag t : lt) {
                    if (t.type() != elementType) {
                        throw new IllegalStateException("Wrong element in list, expected " + elementType + ", got " + t.type());
                    }
                    NBT.writeTag(t, output);
                }
                break;
            }
            case COMPOUND: {
                NBT.writeCompound((CompoundTag)tag, output);
            }
        }
    }

    private static void writeCompound(CompoundTag tag, DataOutput output) throws IOException {
        for (Map.Entry<String, Tag> entry : tag) {
            output.writeByte(entry.getValue().type().id());
            output.writeUTF(entry.getKey());
            NBT.writeTag(entry.getValue(), output);
        }
        output.writeByte(TagType.END.id());
    }

    public static enum Compression {
        NONE,
        GZIP,
        DEFLATE;

    }
}

