/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.nbt;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import org.moddingx.launcherlib.nbt.InvalidNbtException;
import org.moddingx.launcherlib.nbt.tag.ByteArrayTag;
import org.moddingx.launcherlib.nbt.tag.CompoundTag;
import org.moddingx.launcherlib.nbt.tag.IntArrayTag;
import org.moddingx.launcherlib.nbt.tag.ListTag;
import org.moddingx.launcherlib.nbt.tag.LongArrayTag;
import org.moddingx.launcherlib.nbt.tag.NumberTag;
import org.moddingx.launcherlib.nbt.tag.StringTag;
import org.moddingx.launcherlib.nbt.tag.Tag;

public class SNBT {
    public static Tag read(String string) throws InvalidNbtException {
        StringReader sr = new StringReader(string);
        try {
            Tag tag = SNBT.read(sr);
            sr.close();
            return tag;
        }
        catch (Throwable throwable) {
            try {
                try {
                    sr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InvalidNbtException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException on string read.", e);
            }
        }
    }

    public static Tag read(@WillClose Reader in) throws IOException {
        try (Reader reader = in;){
            Tag tag;
            try (TagReader input = new TagReader(in);){
                input.skipSpace();
                if (input.next(2, false).equals("\"\"")) {
                    input.push();
                    if (!input.next(3, true).equals("\"\":")) {
                        input.push();
                    }
                } else {
                    input.push();
                }
                Tag tag2 = SNBT.readTag(input);
                input.skipSpace();
                input.expectEOF();
                tag = tag2;
            }
            return tag;
        }
    }

    public static String write(Tag tag) {
        try {
            StringWriter sw = new StringWriter();
            SNBT.writeTag(tag, sw, false, "");
            sw.close();
            return sw.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException on string write.", e);
        }
    }

    public static void write(Tag tag, @WillClose Writer out) throws IOException {
        SNBT.write(tag, out, false);
    }

    public static void write(Tag tag, @WillClose Writer out, boolean pretty) throws IOException {
        try (Writer writer = out;
             BufferedWriter theWriter = new BufferedWriter(out);){
            SNBT.writeTag(tag, theWriter, pretty, "");
        }
    }

    private static Tag readTag(@WillNotClose TagReader in) throws IOException {
        in.skipSpace();
        Tag result = switch (in.next()) {
            case '[' -> SNBT.readListLike(in);
            case '{' -> SNBT.readCompound(in);
            default -> {
                in.push();
                yield SNBT.readAtom(in, false);
            }
        };
        in.skipSpace();
        return result;
    }

    private static Tag readAtom(@WillNotClose TagReader in, boolean forceString) throws IOException {
        in.skipSpace();
        return switch (in.next()) {
            case '\"' -> {
                StringTag var2_2;
                yield var2_2 = new StringTag(in.readUntil('\"', true));
            }
            case '\'' -> {
                StringTag var2_3;
                yield var2_3 = new StringTag(in.readUntil('\'', true));
            }
            default -> {
                in.push();
                String atom = in.readUnquoted();
                if (forceString) {
                    StringTag var2_4;
                    yield var2_4 = new StringTag(atom);
                }
                if ("false".equals(atom)) {
                    NumberTag var2_5 = NumberTag.createByte(0);
                    yield var2_5;
                }
                if ("true".equals(atom)) {
                    NumberTag var2_6 = NumberTag.createByte(1);
                    yield var2_6;
                }
                if (atom.endsWith("b") || atom.endsWith("B")) {
                    try {
                        NumberTag var2_7 = NumberTag.createByte(Byte.parseByte(atom.substring(0, atom.length() - 1)));
                        yield var2_7;
                    }
                    catch (NumberFormatException var4_16) {
                        // empty catch block
                    }
                }
                if (atom.endsWith("s") || atom.endsWith("S")) {
                    try {
                        NumberTag var2_8 = NumberTag.createShort(Short.parseShort(atom.substring(0, atom.length() - 1)));
                        yield var2_8;
                    }
                    catch (NumberFormatException var4_17) {
                        // empty catch block
                    }
                }
                if (atom.endsWith("l") || atom.endsWith("L")) {
                    try {
                        NumberTag var2_9 = NumberTag.createLong(Long.parseLong(atom.substring(0, atom.length() - 1)));
                        yield var2_9;
                    }
                    catch (NumberFormatException var4_18) {
                        // empty catch block
                    }
                }
                if (atom.endsWith("f") || atom.endsWith("F")) {
                    try {
                        NumberTag var2_10 = NumberTag.createFloat(Float.parseFloat(atom.substring(0, atom.length() - 1)));
                        yield var2_10;
                    }
                    catch (NumberFormatException var4_19) {
                        // empty catch block
                    }
                }
                if (atom.endsWith("d") || atom.endsWith("D")) {
                    try {
                        NumberTag var2_11 = NumberTag.createDouble(Double.parseDouble(atom.substring(0, atom.length() - 1)));
                        yield var2_11;
                    }
                    catch (NumberFormatException var4_20) {
                        // empty catch block
                    }
                }
                try {
                    NumberTag var2_12 = NumberTag.createInt(Integer.parseInt(atom));
                    yield var2_12;
                }
                catch (NumberFormatException var4_21) {
                    try {
                        NumberTag var2_13 = NumberTag.createDouble(Double.parseDouble(atom));
                        yield var2_13;
                    }
                    catch (NumberFormatException var4_22) {
                        StringTag var2_14;
                        yield var2_14 = new StringTag(atom);
                    }
                }
            }
        };
    }

    private static Tag readListLike(@WillNotClose TagReader in) throws IOException {
        in.skipSpace();
        return switch (in.next(2, true)) {
            case "b;", "B;" -> new ByteArrayTag(SNBT.readArray(in, "Byte", NumberTag::asByte));
            case "i;", "I;" -> new IntArrayTag(SNBT.readArray(in, "Int", NumberTag::asInt));
            case "l;", "L;" -> new LongArrayTag(SNBT.readArray(in, "Long", NumberTag::asLong));
            default -> {
                in.push();
                yield new ListTag(SNBT.readList(in));
            }
        };
    }

    private static <T> List<T> readArray(@WillNotClose TagReader in, String content, Function<NumberTag, T> extract) throws IOException {
        in.skipSpace();
        List<Tag> tags = SNBT.readList(in);
        ArrayList<T> list = new ArrayList<T>();
        for (Tag t : tags) {
            if (t instanceof NumberTag) {
                NumberTag n = (NumberTag)t;
                list.add(extract.apply(n));
                continue;
            }
            throw new InvalidNbtException(content + " array can't contain tags of type " + t.type());
        }
        return list;
    }

    private static List<Tag> readList(@WillNotClose TagReader in) throws IOException {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        while (true) {
            in.skipSpace();
            if (in.next() == ']') {
                in.skipSpace();
                return tags;
            }
            in.push();
            tags.add(SNBT.readTag(in));
            in.skipSpace();
            in.expectEither(',', ']');
        }
    }

    private static Tag readCompound(@WillNotClose TagReader in) throws IOException {
        HashMap<String, Tag> tags = new HashMap<String, Tag>();
        while (true) {
            in.skipSpace();
            if (in.next() == '}') {
                in.skipSpace();
                return new CompoundTag(tags);
            }
            in.push();
            Tag keyTag = SNBT.readAtom(in, true);
            if (!(keyTag instanceof StringTag)) {
                throw new InvalidNbtException("Only strings can be keys in compound tags, got " + keyTag.type());
            }
            String key = ((StringTag)keyTag).value();
            in.skipSpace();
            in.expect(':');
            in.skipSpace();
            Tag value = SNBT.readTag(in);
            tags.put(key, value);
            in.skipSpace();
            in.expectEither(',', '}');
        }
    }

    private static void writeTag(Tag tag, @WillNotClose Writer out, boolean pretty, String indent) throws IOException {
        switch (tag.type()) {
            case BYTE: {
                out.write(Byte.toString(((NumberTag)tag).asByte()));
                out.write("b");
                break;
            }
            case SHORT: {
                out.write(Short.toString(((NumberTag)tag).asShort()));
                out.write("s");
                break;
            }
            case INT: {
                out.write(Integer.toString(((NumberTag)tag).asInt()));
                break;
            }
            case LONG: {
                out.write(Long.toString(((NumberTag)tag).asLong()));
                out.write("L");
                break;
            }
            case FLOAT: {
                out.write(Float.toString(((NumberTag)tag).asFloat()));
                out.write("F");
                break;
            }
            case DOUBLE: {
                out.write(Double.toString(((NumberTag)tag).asDouble()));
                out.write("D");
                break;
            }
            case STRING: {
                out.write("\"");
                out.write(((StringTag)tag).value().replace("\\", "\\\\").replace("\"", "\\\"").replace("'", "\\'"));
                out.write("\"");
                break;
            }
            case BYTE_ARRAY: {
                out.write(pretty ? "[B;\n" : "[B;");
                boolean first = true;
                Iterator iterator = ((ByteArrayTag)tag).iterator();
                while (iterator.hasNext()) {
                    byte b = (Byte)iterator.next();
                    if (!first) {
                        out.write(pretty ? ",\n" : ",");
                    }
                    first = false;
                    if (pretty) {
                        out.write(indent + "  ");
                    }
                    out.write(Byte.toString(b));
                    out.write("b");
                }
                out.write((String)(pretty ? "\n" + indent + "]" : "]"));
                break;
            }
            case INT_ARRAY: {
                out.write(pretty ? "[I;\n" : "[I;");
                boolean first = true;
                Iterator iterator = ((IntArrayTag)tag).iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    if (!first) {
                        out.write(pretty ? ",\n" : ",");
                    }
                    first = false;
                    if (pretty) {
                        out.write(indent + "  ");
                    }
                    out.write(Integer.toString(i));
                }
                out.write((String)(pretty ? "\n" + indent + "]" : "]"));
                break;
            }
            case LONG_ARRAY: {
                out.write(pretty ? "[L;\n" : "[L;");
                boolean first = true;
                Iterator iterator = ((LongArrayTag)tag).iterator();
                while (iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    if (!first) {
                        out.write(pretty ? ",\n" : ",");
                    }
                    first = false;
                    if (pretty) {
                        out.write(indent + "  ");
                    }
                    out.write(Long.toString(l));
                    out.write("L");
                }
                out.write((String)(pretty ? "\n" + indent + "]" : "]"));
                break;
            }
            case LIST: {
                out.write(pretty ? "[\n" : "[");
                boolean first = true;
                for (Tag t : (ListTag)tag) {
                    if (!first) {
                        out.write(pretty ? ",\n" : ",");
                    }
                    first = false;
                    if (pretty) {
                        out.write(indent + "  ");
                    }
                    SNBT.writeTag(t, out, pretty, indent + "  ");
                }
                out.write((String)(pretty ? "\n" + indent + "]" : "]"));
                break;
            }
            case COMPOUND: {
                out.write(pretty ? "{\n" : "{");
                boolean first = true;
                CompoundTag itr = pretty ? ((CompoundTag)tag).stream().sorted(Map.Entry.comparingByKey()).toList() : (CompoundTag)tag;
                for (Map.Entry entry : itr) {
                    if (!first) {
                        out.write(pretty ? ",\n" : ",");
                    }
                    first = false;
                    if (pretty) {
                        out.write(indent + "  ");
                    }
                    out.write("\"");
                    out.write(((String)entry.getKey()).replace("\\", "\\\\").replace("\"", "\\\"").replace("'", "\\'"));
                    out.write(pretty ? "\": " : "\":");
                    SNBT.writeTag((Tag)entry.getValue(), out, pretty, indent + "  ");
                }
                out.write((String)(pretty ? "\n" + indent + "}" : "}"));
            }
        }
    }

    private static class TagReader
    implements Closeable {
        private final PushbackReader in;
        private String last;

        private TagReader(Reader in) {
            this.in = new PushbackReader(in, 8);
        }

        public void skipSpace() throws IOException {
            int next;
            do {
                if ((next = this.in.read()) >= 0) continue;
                return;
            } while (Character.isWhitespace((char)next) || Character.isSpaceChar((char)next));
            this.in.unread((char)next);
        }

        public char next() throws IOException {
            int r = this.in.read();
            if (r < 0) {
                throw new EOFException();
            }
            this.last = Character.toString((char)r);
            return (char)r;
        }

        public String next(int len, boolean ignoreSpaces) throws IOException {
            int r;
            StringBuilder res = new StringBuilder();
            StringBuilder lst = new StringBuilder();
            int cl = 0;
            while (cl < len && (r = this.in.read()) >= 0) {
                lst.append((char)r);
                if (ignoreSpaces && (Character.isWhitespace((char)r) || Character.isSpaceChar((char)r))) continue;
                res.append((char)r);
                ++cl;
            }
            this.last = lst.toString();
            return res.toString();
        }

        public void push() throws IOException {
            this.in.unread(this.last.toCharArray());
        }

        public String readUntil(char delim, boolean unescape) throws IOException {
            StringBuilder sb = new StringBuilder();
            boolean esc = false;
            while (true) {
                int next;
                if ((next = this.in.read()) < 0) {
                    throw new EOFException();
                }
                if (unescape && esc) {
                    sb.append((char)next);
                    esc = false;
                    continue;
                }
                if (delim == (char)next) {
                    return sb.toString();
                }
                if (unescape && '\\' == (char)next) {
                    esc = true;
                    continue;
                }
                sb.append((char)next);
            }
        }

        public String readUnquoted() throws IOException {
            char chr;
            StringBuilder sb = new StringBuilder();
            while (true) {
                int next;
                if ((next = this.in.read()) < 0) {
                    return sb.toString();
                }
                chr = (char)next;
                if (!(chr >= 'A' && chr <= 'Z' || chr >= 'a' && chr <= 'z' || chr >= '0' && chr <= '9' || chr == '_' || chr == '-' || chr == '.') && chr != '+') break;
                sb.append(chr);
            }
            this.in.unread(chr);
            return sb.toString();
        }

        public void expect(char chr) throws IOException {
            int next = this.in.read();
            if (next < 0) {
                throw new EOFException();
            }
            if (chr != (char)next) {
                throw new InvalidNbtException("Expected '" + chr + "', got '" + (char)next + "'");
            }
        }

        public void expectEither(char skip, char noSkip) throws IOException {
            int next = this.in.read();
            if (next < 0) {
                throw new EOFException();
            }
            if (skip == (char)next) {
                return;
            }
            if (noSkip == (char)next) {
                this.in.unread((char)next);
                return;
            }
            throw new InvalidNbtException("Expected '" + skip + "' or '" + noSkip + "', got '" + (char)next + "'");
        }

        public void expectEOF() throws IOException {
            int next = this.in.read();
            if (next >= 0) {
                throw new InvalidNbtException("Expected <EOF>, got '" + (char)next + "'");
            }
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }
}

