/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.nbt.tag;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.moddingx.launcherlib.nbt.SNBT;
import org.moddingx.launcherlib.nbt.TagType;
import org.moddingx.launcherlib.nbt.tag.Tag;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ArrayTag<T>
implements Tag,
Iterable<T> {
    private final TagType type;
    protected final List<T> elements;

    protected ArrayTag(TagType type, List<T> elements) {
        this.type = type;
        this.elements = new ArrayList<T>(elements);
    }

    @Override
    public TagType type() {
        return this.type;
    }

    @Override
    public abstract ArrayTag<T> copy();

    public final String toString() {
        return SNBT.write(this);
    }

    public int size() {
        return this.elements.size();
    }

    public T get(int idx) {
        return this.elements.get(idx);
    }

    public void add(T value) {
        this.onAdd(value);
        this.elements.add(value);
    }

    public void add(int idx, T value) {
        this.onAdd(value);
        this.elements.add(idx, value);
    }

    public void addAll(List<T> values) {
        values.forEach(this::onAdd);
        this.elements.addAll(values);
    }

    public void addAll(int idx, List<T> values) {
        values.forEach(this::onAdd);
        this.elements.addAll(idx, values);
    }

    public void set(int idx, T value) {
        this.elements.set(idx, value);
    }

    public T remove(int idx) {
        return this.elements.remove(idx);
    }

    public void clear() {
        this.elements.clear();
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Nonnull
    public ListIterator<T> listIterator() {
        return this.elements.listIterator();
    }

    @Nonnull
    public ListIterator<T> listIterator(int idx) {
        return this.elements.listIterator(idx);
    }

    @Nonnull
    public Stream<T> stream() {
        return this.elements.stream();
    }

    protected void onAdd(T elem) {
    }
}

