/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.nbt.tag;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.moddingx.launcherlib.nbt.TagType;
import org.moddingx.launcherlib.nbt.tag.ArrayTag;

public final class ByteArrayTag
extends ArrayTag<Byte> {
    public ByteArrayTag() {
        super(TagType.BYTE_ARRAY, List.of());
    }

    public ByteArrayTag(byte[] elements) {
        super(TagType.BYTE_ARRAY, ByteArrayTag.makeList(elements));
    }

    public ByteArrayTag(List<Byte> elements) {
        super(TagType.BYTE_ARRAY, elements);
    }

    @Override
    public ByteArrayTag copy() {
        return new ByteArrayTag(this.elements);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof ByteArrayTag)) return false;
        ByteArrayTag bt = (ByteArrayTag)other;
        if (!Objects.equals(this.elements, bt.elements)) return false;
        return true;
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    private static List<Byte> makeList(byte[] data) {
        ArrayList<Byte> list = new ArrayList<Byte>(data.length);
        for (byte b : data) {
            list.add(b);
        }
        return list;
    }
}

