/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.nbt.tag;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.moddingx.launcherlib.nbt.SNBT;
import org.moddingx.launcherlib.nbt.TagType;
import org.moddingx.launcherlib.nbt.tag.ListTag;
import org.moddingx.launcherlib.nbt.tag.NumberTag;
import org.moddingx.launcherlib.nbt.tag.StringTag;
import org.moddingx.launcherlib.nbt.tag.Tag;

public final class CompoundTag
implements Tag,
Iterable<Map.Entry<String, Tag>> {
    private final Map<String, Tag> elements;

    public CompoundTag() {
        this.elements = new HashMap<String, Tag>();
    }

    public CompoundTag(Map<String, Tag> elements) {
        this.elements = new HashMap<String, Tag>(elements);
    }

    @Override
    public TagType type() {
        return TagType.COMPOUND;
    }

    @Override
    public CompoundTag copy() {
        return new CompoundTag(this.elements.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Tag)entry.getValue()).copy())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof CompoundTag)) return false;
        CompoundTag ct = (CompoundTag)other;
        if (!Objects.equals(this.elements, ct.elements)) return false;
        return true;
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public String toString() {
        return SNBT.write(this);
    }

    public int size() {
        return this.elements.size();
    }

    public boolean has(String key) {
        return this.elements.containsKey(key);
    }

    public boolean has(String key, TagType type) {
        return this.elements.containsKey(key) && this.elements.get(key).type() == type;
    }

    public Tag get(String key) {
        if (!this.elements.containsKey(key)) {
            throw new NoSuchElementException(key);
        }
        return this.elements.get(key);
    }

    public Tag put(String key, Tag value) {
        return this.elements.put(key, value);
    }

    public Tag put(Map.Entry<String, Tag> entry) {
        return this.elements.put(entry.getKey(), entry.getValue());
    }

    public void putAll(CompoundTag tag) {
        this.elements.putAll(tag.copy().elements);
    }

    public void putAll(Map<String, Tag> values) {
        this.elements.putAll(values);
    }

    public void merge(CompoundTag tag) {
        for (Map.Entry<String, Tag> entry : tag) {
            Tag tag2;
            if (this.has(entry.getKey(), TagType.COMPOUND) && (tag2 = entry.getValue()) instanceof CompoundTag) {
                CompoundTag cmp = (CompoundTag)tag2;
                this.getCompound(entry.getKey()).merge(cmp);
                continue;
            }
            this.put(entry);
        }
    }

    public Tag remove(String key) {
        return this.elements.remove(key);
    }

    public void clear() {
        this.elements.clear();
    }

    public Set<String> keys() {
        return this.elements.keySet();
    }

    public byte getByte(String key) {
        byte by;
        Tag tag = this.get(key);
        if (tag instanceof NumberTag) {
            NumberTag num = (NumberTag)tag;
            by = num.asByte();
        } else {
            by = 0;
        }
        return by;
    }

    public short getShort(String key) {
        short s;
        Tag tag = this.get(key);
        if (tag instanceof NumberTag) {
            NumberTag num = (NumberTag)tag;
            s = num.asShort();
        } else {
            s = 0;
        }
        return s;
    }

    public int getInt(String key) {
        int n;
        Tag tag = this.get(key);
        if (tag instanceof NumberTag) {
            NumberTag num = (NumberTag)tag;
            n = num.asInt();
        } else {
            n = 0;
        }
        return n;
    }

    public long getLong(String key) {
        long l;
        Tag tag = this.get(key);
        if (tag instanceof NumberTag) {
            NumberTag num = (NumberTag)tag;
            l = num.asLong();
        } else {
            l = 0L;
        }
        return l;
    }

    public float getFloat(String key) {
        float f;
        Tag tag = this.get(key);
        if (tag instanceof NumberTag) {
            NumberTag num = (NumberTag)tag;
            f = num.asFloat();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public double getDouble(String key) {
        double d;
        Tag tag = this.get(key);
        if (tag instanceof NumberTag) {
            NumberTag num = (NumberTag)tag;
            d = num.asDouble();
        } else {
            d = 0.0;
        }
        return d;
    }

    public String getString(String key) {
        String string;
        Tag tag = this.get(key);
        if (tag == null) {
            return "";
        }
        if (tag instanceof StringTag) {
            StringTag str = (StringTag)tag;
            string = str.value();
        } else {
            string = SNBT.write(tag);
        }
        return string;
    }

    public ListTag getList(String key) {
        return (ListTag)Objects.requireNonNull(this.get(key));
    }

    public CompoundTag getCompound(String key) {
        return (CompoundTag)Objects.requireNonNull(this.get(key));
    }

    public void putByte(String key, byte value) {
        this.put(key, NumberTag.createByte(value));
    }

    public void putShort(String key, short value) {
        this.put(key, NumberTag.createShort(value));
    }

    public void putInt(String key, int value) {
        this.put(key, NumberTag.createInt(value));
    }

    public void putLong(String key, long value) {
        this.put(key, NumberTag.createLong(value));
    }

    public void putFloat(String key, float value) {
        this.put(key, NumberTag.createFloat(value));
    }

    public void putDouble(String key, double value) {
        this.put(key, NumberTag.createDouble(value));
    }

    public void putString(String key, String value) {
        this.put(key, new StringTag(value));
    }

    @Override
    @Nonnull
    public Iterator<Map.Entry<String, Tag>> iterator() {
        return this.elements.entrySet().iterator();
    }

    @Nonnull
    public Stream<Map.Entry<String, Tag>> stream() {
        return this.elements.entrySet().stream();
    }
}

