/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.nbt.tag;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.moddingx.launcherlib.nbt.TagType;
import org.moddingx.launcherlib.nbt.tag.ArrayTag;

public final class IntArrayTag
extends ArrayTag<Integer> {
    public IntArrayTag() {
        super(TagType.INT_ARRAY, List.of());
    }

    public IntArrayTag(int[] elements) {
        super(TagType.INT_ARRAY, Arrays.stream(elements).boxed().toList());
    }

    public IntArrayTag(List<Integer> elements) {
        super(TagType.INT_ARRAY, elements);
    }

    @Override
    public IntArrayTag copy() {
        return new IntArrayTag(this.elements);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof IntArrayTag)) return false;
        IntArrayTag it = (IntArrayTag)other;
        if (!Objects.equals(this.elements, it.elements)) return false;
        return true;
    }

    public int hashCode() {
        return this.elements.hashCode();
    }
}

