/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.nbt.tag;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.moddingx.launcherlib.nbt.SNBT;
import org.moddingx.launcherlib.nbt.TagType;
import org.moddingx.launcherlib.nbt.tag.ArrayTag;
import org.moddingx.launcherlib.nbt.tag.CompoundTag;
import org.moddingx.launcherlib.nbt.tag.NumberTag;
import org.moddingx.launcherlib.nbt.tag.StringTag;
import org.moddingx.launcherlib.nbt.tag.Tag;

public final class ListTag
extends ArrayTag<Tag> {
    private TagType elementType;

    public ListTag() {
        super(TagType.LIST, List.of());
        this.updateElementType();
    }

    public ListTag(List<Tag> elements) {
        super(TagType.LIST, elements);
        this.updateElementType();
    }

    private ListTag(TagType elementType, List<Tag> elements) {
        super(TagType.LIST, elements);
        this.elementType = elementType;
    }

    private void updateElementType() {
        if (this.elements.size() == 0) {
            this.elementType = TagType.END;
        } else {
            List<TagType> allTypes = this.elements.stream().map(Tag::type).distinct().toList();
            if (allTypes.size() == 1) {
                this.elementType = allTypes.get(0);
            } else {
                throw new IllegalArgumentException("List of different tag types: " + allTypes.stream().map(Enum::name).collect(Collectors.joining(", ")));
            }
        }
    }

    @Override
    protected void onAdd(Tag newElement) {
        if (this.elementType == TagType.END) {
            this.elementType = newElement.type();
        } else if (this.elementType != newElement.type()) {
            throw new IllegalArgumentException("Invalid element type: expected " + this.elementType + ", got " + newElement.type());
        }
    }

    @Override
    public void set(int idx, Tag value) {
        if (this.size() >= 2) {
            if (this.elementType != value.type()) {
                throw new IllegalArgumentException("Invalid element type: expected " + this.elementType + ", got " + value.type());
            }
            super.set(idx, value);
        } else {
            super.set(idx, value);
            this.updateElementType();
        }
    }

    @Override
    public Tag remove(int idx) {
        Tag result = (Tag)super.remove(idx);
        if (this.elements.isEmpty()) {
            this.elementType = TagType.END;
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.elementType = TagType.END;
    }

    public TagType elementType() {
        return this.elements.isEmpty() ? TagType.END : this.elementType;
    }

    @Override
    public ListTag copy() {
        return new ListTag(this.elementType, this.elements.stream().map(Tag::copy).toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof ListTag)) return false;
        ListTag lt = (ListTag)other;
        if (!Objects.equals(this.elements, lt.elements)) return false;
        return true;
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public void addAll(ListTag tag) {
        this.addAll(tag.elements.stream().map(Tag::copy).toList());
    }

    public void addAll(int idx, ListTag tag) {
        this.addAll(idx, tag.elements.stream().map(Tag::copy).toList());
    }

    public byte getByte(int idx) {
        byte by;
        Object t = this.get(idx);
        if (t instanceof NumberTag) {
            NumberTag num = (NumberTag)t;
            by = num.asByte();
        } else {
            by = 0;
        }
        return by;
    }

    public short getShort(int idx) {
        short s;
        Object t = this.get(idx);
        if (t instanceof NumberTag) {
            NumberTag num = (NumberTag)t;
            s = num.asShort();
        } else {
            s = 0;
        }
        return s;
    }

    public int getInt(int idx) {
        int n;
        Object t = this.get(idx);
        if (t instanceof NumberTag) {
            NumberTag num = (NumberTag)t;
            n = num.asInt();
        } else {
            n = 0;
        }
        return n;
    }

    public long getLong(int idx) {
        long l;
        Object t = this.get(idx);
        if (t instanceof NumberTag) {
            NumberTag num = (NumberTag)t;
            l = num.asLong();
        } else {
            l = 0L;
        }
        return l;
    }

    public float getFloat(int idx) {
        float f;
        Object t = this.get(idx);
        if (t instanceof NumberTag) {
            NumberTag num = (NumberTag)t;
            f = num.asFloat();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public double getDouble(int idx) {
        double d;
        Object t = this.get(idx);
        if (t instanceof NumberTag) {
            NumberTag num = (NumberTag)t;
            d = num.asDouble();
        } else {
            d = 0.0;
        }
        return d;
    }

    public String getString(int idx) {
        String string;
        Tag tag = (Tag)this.get(idx);
        if (tag == null) {
            return "";
        }
        if (tag instanceof StringTag) {
            StringTag str = (StringTag)tag;
            string = str.value();
        } else {
            string = SNBT.write(tag);
        }
        return string;
    }

    public ListTag getList(int idx) {
        return (ListTag)Objects.requireNonNull((Tag)this.get(idx));
    }

    public CompoundTag getCompound(int idx) {
        return (CompoundTag)Objects.requireNonNull((Tag)this.get(idx));
    }

    public void addByte(byte value) {
        this.add(NumberTag.createByte(value));
    }

    public void addShort(short value) {
        this.add(NumberTag.createShort(value));
    }

    public void addInt(int value) {
        this.add(NumberTag.createInt(value));
    }

    public void addLong(long value) {
        this.add(NumberTag.createLong(value));
    }

    public void addFloat(float value) {
        this.add(NumberTag.createFloat(value));
    }

    public void addDouble(double value) {
        this.add(NumberTag.createDouble(value));
    }

    public void addString(String value) {
        this.add(new StringTag(value));
    }

    public void setByte(int idx, byte value) {
        this.set(idx, NumberTag.createByte(value));
    }

    public void setShort(int idx, short value) {
        this.set(idx, NumberTag.createShort(value));
    }

    public void setInt(int idx, int value) {
        this.set(idx, NumberTag.createInt(value));
    }

    public void setLong(int idx, long value) {
        this.set(idx, NumberTag.createLong(value));
    }

    public void setFloat(int idx, float value) {
        this.set(idx, NumberTag.createFloat(value));
    }

    public void setDouble(int idx, double value) {
        this.set(idx, NumberTag.createDouble(value));
    }

    public void setString(int idx, String value) {
        this.set(idx, new StringTag(value));
    }
}

