/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.nbt.tag;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.moddingx.launcherlib.nbt.TagType;
import org.moddingx.launcherlib.nbt.tag.ArrayTag;

public final class LongArrayTag
extends ArrayTag<Long> {
    public LongArrayTag() {
        super(TagType.LONG_ARRAY, List.of());
    }

    public LongArrayTag(long[] elements) {
        super(TagType.LONG_ARRAY, Arrays.stream(elements).boxed().toList());
    }

    public LongArrayTag(List<Long> elements) {
        super(TagType.LONG_ARRAY, elements);
    }

    @Override
    public LongArrayTag copy() {
        return new LongArrayTag(this.elements);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof LongArrayTag)) return false;
        LongArrayTag lt = (LongArrayTag)other;
        if (!Objects.equals(this.elements, lt.elements)) return false;
        return true;
    }

    public int hashCode() {
        return this.elements.hashCode();
    }
}

