/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.nbt.tag;

import java.util.Objects;
import org.moddingx.launcherlib.nbt.SNBT;
import org.moddingx.launcherlib.nbt.TagType;
import org.moddingx.launcherlib.nbt.tag.Tag;

public final class NumberTag
implements Tag {
    private static final NumberTag FALSE = new NumberTag(TagType.BYTE, (byte)0);
    private static final NumberTag TRUE = new NumberTag(TagType.BYTE, (byte)1);
    private static final NumberTag ZERO = new NumberTag(TagType.INT, 0);
    private final TagType type;
    private final Number value;

    private NumberTag(TagType type, Number value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public TagType type() {
        return this.type;
    }

    @Override
    public NumberTag copy() {
        return this;
    }

    public String toString() {
        return SNBT.write(this);
    }

    public byte asByte() {
        return this.value.byteValue();
    }

    public short asShort() {
        return this.value.shortValue();
    }

    public int asInt() {
        return this.value.intValue();
    }

    public long asLong() {
        return this.value.longValue();
    }

    public float asFloat() {
        return this.value.floatValue();
    }

    public double asDouble() {
        return this.value.doubleValue();
    }

    public Number value() {
        return this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof NumberTag)) return false;
        NumberTag nt = (NumberTag)other;
        if (this.type != nt.type) return false;
        if (!Objects.equals(this.value, nt.value)) return false;
        return true;
    }

    public int hashCode() {
        return this.type.id() + this.value.intValue();
    }

    public static NumberTag createByte(int value) {
        if (value == 0) {
            return FALSE;
        }
        if (value == 1) {
            return TRUE;
        }
        return new NumberTag(TagType.BYTE, (byte)value);
    }

    public static NumberTag createShort(int value) {
        return new NumberTag(TagType.SHORT, (short)value);
    }

    public static NumberTag createInt(int value) {
        if (value == 0) {
            return ZERO;
        }
        return new NumberTag(TagType.INT, value);
    }

    public static NumberTag createLong(long value) {
        return new NumberTag(TagType.LONG, value);
    }

    public static NumberTag createFloat(float value) {
        return new NumberTag(TagType.FLOAT, Float.valueOf(value));
    }

    public static NumberTag createDouble(double value) {
        return new NumberTag(TagType.DOUBLE, value);
    }
}

