/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.util;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Either<A, B> {
    public Optional<A> left();

    public Optional<B> right();

    public Either<B, A> swap();

    public <T> Either<T, B> mapLeft(Function<A, T> var1);

    public <T> Either<A, T> mapRight(Function<B, T> var1);

    default public <T, U> Either<T, U> map(Function<A, T> leftMapper, Function<B, U> rightMapper) {
        return this.mapLeft(leftMapper).mapRight(rightMapper);
    }

    default public <T> T get(Function<A, T> funcA, Function<B, T> funcB) {
        Optional<A> a = this.left();
        if (a.isPresent()) {
            return funcA.apply(a.get());
        }
        return funcB.apply(this.right().get());
    }

    default public <T, E extends Throwable> T getOrThrow(Function<A, T> funcA, Function<B, ? extends E> funcB) throws E {
        Optional<A> a = this.left();
        if (a.isPresent()) {
            return funcA.apply(a.get());
        }
        throw (Throwable)funcB.apply(this.right().get());
    }

    public static <A, B> Either<A, B> left(A a) {
        return new Left<A>(a);
    }

    public static <A, B> Either<A, B> right(B b) {
        return new Right<B>(b);
    }

    public static <T> Either<T, RuntimeException> tryWith(Supplier<T> action) {
        try {
            return Either.left(action.get());
        }
        catch (RuntimeException e) {
            return Either.right(e);
        }
    }

    public record Left<A>(A value) implements Either<A, Void>
    {
        @Override
        public Optional<A> left() {
            return Optional.of(this.value());
        }

        @Override
        public Optional<Void> right() {
            return Optional.empty();
        }

        @Override
        public Either<Void, A> swap() {
            return new Right<A>(this.value());
        }

        @Override
        public <T> Either<T, Void> mapLeft(Function<A, T> mapper) {
            return new Left<T>(mapper.apply(this.value()));
        }

        @Override
        public <T> Either<A, T> mapRight(Function<Void, T> mapper) {
            return this;
        }
    }

    public record Right<B>(B value) implements Either<Void, B>
    {
        @Override
        public Optional<Void> left() {
            return Optional.empty();
        }

        @Override
        public Optional<B> right() {
            return Optional.of(this.value());
        }

        @Override
        public Either<B, Void> swap() {
            return new Left<B>(this.value());
        }

        @Override
        public <T> Either<T, B> mapLeft(Function<Void, T> mapper) {
            return this;
        }

        @Override
        public <T> Either<Void, T> mapRight(Function<B, T> mapper) {
            return new Right<T>(mapper.apply(this.value()));
        }
    }
}

