/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.launcherlib.util;

import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;

public enum Side {
    CLIENT("client", true, false),
    SERVER("server", false, true),
    COMMON("common", true, true);

    public final String id;
    public final boolean client;
    public final boolean server;

    private Side(String id, boolean client, boolean server) {
        this.id = id;
        this.client = client;
        this.server = server;
    }

    public static Side byId(String id) {
        return switch (id.toLowerCase(Locale.ROOT)) {
            case "client" -> CLIENT;
            case "server" -> SERVER;
            case "common" -> COMMON;
            default -> throw new IllegalArgumentException("Unknown side: " + id);
        };
    }

    @Nullable
    public static Side get(boolean client, boolean server) {
        if (client && server) {
            return COMMON;
        }
        if (client) {
            return CLIENT;
        }
        if (server) {
            return SERVER;
        }
        return null;
    }

    public static Side merge(Side ... sides) {
        boolean client = false;
        boolean server = false;
        for (Side side : sides) {
            if (side.client) {
                client = true;
            }
            if (!side.server) continue;
            server = true;
        }
        return Objects.requireNonNullElse(Side.get(client, server), COMMON);
    }

    @Nullable
    public static Side and(Side ... sides) {
        boolean client = true;
        boolean server = true;
        for (Side side : sides) {
            if (!side.client) {
                client = false;
            }
            if (side.server) continue;
            server = false;
        }
        if (!client && !server) {
            return null;
        }
        return Side.get(client, server);
    }
}

