/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.annotation.processor.modinit;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.moddingx.libx.annotation.processor.Classes;
import org.moddingx.libx.annotation.processor.modinit.codec.GeneratedCodec;
import org.moddingx.libx.annotation.processor.modinit.config.RegisteredConfig;
import org.moddingx.libx.annotation.processor.modinit.config.RegisteredMapper;
import org.moddingx.libx.annotation.processor.modinit.data.DatagenEntry;
import org.moddingx.libx.annotation.processor.modinit.model.LoadableModel;
import org.moddingx.libx.annotation.processor.modinit.register.RegistrationEntry;

public class ModInit {
    public static final List<String> DEFAULT_PARAM_CODEC_FIELDS = List.of("CODEC", "DIRECT_CODEC");
    public final String modid;
    public final Element modClass;
    private final Map<Integer, List<RegistrationEntry>> registration = new HashMap<Integer, List<RegistrationEntry>>();
    private final List<LoadableModel> models = new ArrayList<LoadableModel>();
    private final List<RegisteredMapper> configMappers = new ArrayList<RegisteredMapper>();
    private final List<RegisteredConfig> configs = new ArrayList<RegisteredConfig>();
    private final List<GeneratedCodec> codecs = new ArrayList<GeneratedCodec>();
    private final List<DatagenEntry> datagen = new ArrayList<DatagenEntry>();

    public ModInit(String modid, Element modClass, Messager messager) {
        this.modid = modid;
        this.modClass = modClass;
        if (modClass.getEnclosingElement().getKind() != ElementKind.PACKAGE || !(modClass.getEnclosingElement() instanceof PackageElement)) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Parent element of mod class is not a package", modClass);
        }
    }

    public void addRegistration(int priority, List<RegistrationEntry> entries) {
        if (!this.registration.containsKey(priority)) {
            this.registration.put(priority, new ArrayList());
        }
        List<RegistrationEntry> list = this.registration.get(priority);
        list.addAll(entries);
    }

    public void addModel(String classFqn, String fieldName, String modelNamespace, String modelPath) {
        this.models.add(new LoadableModel(classFqn, fieldName, modelNamespace.isEmpty() ? this.modid : modelNamespace, modelPath));
    }

    public void addConfigMapper(String classFqn, @Nullable String requiresMod, boolean genericType) {
        this.configMappers.add(new RegisteredMapper(classFqn, requiresMod, genericType));
    }

    public void addConfig(String name, boolean client, @Nullable String requiresMod, String classFqn) {
        this.configs.add(new RegisteredConfig(name, client, requiresMod, classFqn));
    }

    public void addCodec(GeneratedCodec codec) {
        this.codecs.add(codec);
    }

    public void addDatagen(String classFqn, List<DatagenEntry.Arg> ctorArgs) {
        this.datagen.add(new DatagenEntry(classFqn, ctorArgs));
    }

    public void write(Filer filer, Messager messager) {
        try {
            List allReg = this.registration.entrySet().stream().sorted(Comparator.comparingInt(e -> -((Integer)e.getKey()).intValue())).flatMap(e -> ((List)e.getValue()).stream()).toList();
            JavaFileObject file = filer.createSourceFile(((PackageElement)this.modClass.getEnclosingElement()).getQualifiedName() + "." + this.modClass.getSimpleName() + "$", this.modClass);
            Writer writer = file.openWriter();
            writer.write("package " + ((PackageElement)this.modClass.getEnclosingElement()).getQualifiedName() + ";");
            writer.write("@" + SuppressWarnings.class.getCanonicalName() + "({\"all\",\"unchecked\",\"rawtypes\",\"deprecation\"})");
            writer.write("public class " + this.modClass.getSimpleName() + "${");
            writer.write("private static " + Classes.sourceName("org.moddingx.libx.mod.ModX") + " mod=null;");
            if (!this.codecs.isEmpty()) {
                writer.write("public static final " + Map.class.getCanonicalName() + "<Class<?>," + Classes.sourceName("com.mojang.serialization.Codec") + "<?>>codecs=buildCodecs();");
                writer.write("private static final " + Map.class.getCanonicalName() + "<Class<?>," + Classes.sourceName("com.mojang.serialization.Codec") + "<?>>buildCodecs(){");
                writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.LazyMapBuilder") + " builder=" + Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".lazyMapBuilder();");
                for (GeneratedCodec generatedCodec : this.codecs) {
                    GeneratedCodec.CodecElement param;
                    int i;
                    writer.write("builder.put(" + generatedCodec.fqn() + ".class,");
                    writer.write("() -> " + Classes.sourceName("com.mojang.serialization.codecs.RecordCodecBuilder") + ".<" + generatedCodec.fqn() + ">create(instance->");
                    writer.write("instance.group(");
                    for (i = 0; i < generatedCodec.params().size(); ++i) {
                        param = generatedCodec.params().get(i);
                        writer.write("(");
                        param.writeCode(writer);
                        writer.write(")");
                        if (i >= generatedCodec.params().size() - 1) continue;
                        writer.write(",");
                    }
                    writer.write(").apply(instance,instance.stable(");
                    writer.write("(");
                    for (i = 0; i < generatedCodec.params().size(); ++i) {
                        param = generatedCodec.params().get(i);
                        writer.write(param.typeFqnBoxed + " ctorArg" + i);
                        if (i >= generatedCodec.params().size() - 1) continue;
                        writer.write(",");
                    }
                    writer.write(")->{");
                    writer.write("return new " + generatedCodec.fqn() + "(");
                    for (i = 0; i < generatedCodec.params().size(); ++i) {
                        writer.write("ctorArg" + i);
                        if (i >= generatedCodec.params().size() - 1) continue;
                        writer.write(",");
                    }
                    writer.write(");");
                    writer.write("}");
                    writer.write("))");
                    writer.write("));");
                }
                writer.write("return builder.build();");
                writer.write("}");
            }
            writer.write("public static void init(" + Classes.sourceName("org.moddingx.libx.mod.ModX") + " mod){");
            writer.write(this.modClass.getSimpleName() + "$.mod=mod;");
            for (RegisteredMapper registeredMapper : this.configMappers) {
                if (registeredMapper.requiresMod() != null) {
                    writer.write("if(" + Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".isModLoaded(" + ModInit.quote(registeredMapper.requiresMod()) + ")){");
                }
                writer.write(Classes.sourceName("org.moddingx.libx.config.ConfigManager") + ".registerValueMapper(" + ModInit.quote(this.modid) + ",new " + registeredMapper.classFqn() + (registeredMapper.genericType() ? "<>" : "") + "());");
                if (registeredMapper.requiresMod() == null) continue;
                writer.write("}");
            }
            for (RegisteredConfig registeredConfig : this.configs) {
                if (registeredConfig.requiresMod() != null) {
                    writer.write("if(" + Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".isModLoaded(" + ModInit.quote(registeredConfig.requiresMod()) + ")){");
                }
                writer.write(Classes.sourceName("org.moddingx.libx.config.ConfigManager") + ".registerConfig(" + Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".newRL(" + ModInit.quote(this.modid) + "," + ModInit.quote(registeredConfig.name()) + ")," + registeredConfig.classFqn() + ".class," + registeredConfig.client() + ");");
                if (registeredConfig.requiresMod() == null) continue;
                writer.write("}");
            }
            if (!allReg.isEmpty()) {
                writer.write("((" + Classes.sourceName("org.moddingx.libx.mod.ModXRegistration") + ")mod).addRegistrationHandler(" + this.modClass.getSimpleName() + "$::register);");
            }
            if (!this.models.isEmpty()) {
                writer.write(Classes.sourceName("net.minecraftforge.fml.DistExecutor") + ".unsafeRunWhenOn(" + Classes.sourceName("net.minecraftforge.api.distmarker.Dist") + ".CLIENT,()->()->{");
                writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".addModListener(" + Classes.sourceName("net.minecraftforge.client.event.ModelEvent$RegisterAdditional") + ".class," + this.modClass.getSimpleName() + "$::registerModels);");
                writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".addLowModListener(" + Classes.sourceName("net.minecraftforge.client.event.ModelEvent$BakingCompleted") + ".class," + this.modClass.getSimpleName() + "$::bakeModels);");
                writer.write("});");
            }
            if (!this.datagen.isEmpty()) {
                writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".addModListener(" + Classes.sourceName("net.minecraftforge.data.event.GatherDataEvent") + ".class," + this.modClass.getSimpleName() + "$::gatherData);");
            }
            writer.write("}");
            if (!allReg.isEmpty()) {
                writer.write("private static void register(){");
                writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".runUnchecked(()->{");
                for (RegistrationEntry registrationEntry : allReg) {
                    writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".register(mod," + (registrationEntry.registryFqn() == null ? "null" : registrationEntry.registryFqn()) + "," + ModInit.quote(registrationEntry.name()) + "," + registrationEntry.fieldClassFqn() + "." + registrationEntry.fieldName() + ",()->{return " + registrationEntry.fieldClassFqn() + ".class.getDeclaredField(" + ModInit.quote(registrationEntry.fieldName()) + ");}," + (registrationEntry.multi() ? "true" : "false") + ");");
                }
                writer.write("});");
                writer.write("}");
            }
            if (!this.models.isEmpty()) {
                writer.write("@" + Classes.sourceName("net.minecraftforge.api.distmarker.OnlyIn") + "(" + Classes.sourceName("net.minecraftforge.api.distmarker.Dist") + ".CLIENT)");
                writer.write("private static void registerModels(" + Classes.sourceName("net.minecraftforge.client.event.ModelEvent$RegisterAdditional") + " event){");
                for (LoadableModel loadableModel : this.models) {
                    writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".addSpecialModel(event," + Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".newRL(" + ModInit.quote(loadableModel.modelNamespace()) + "," + ModInit.quote(loadableModel.modelPath()) + "));");
                }
                writer.write("}");
                writer.write("@" + Classes.sourceName("net.minecraftforge.api.distmarker.OnlyIn") + "(" + Classes.sourceName("net.minecraftforge.api.distmarker.Dist") + ".CLIENT)");
                writer.write("private static void bakeModels(" + Classes.sourceName("net.minecraftforge.client.event.ModelEvent$BakingCompleted") + " event){");
                for (LoadableModel loadableModel : this.models) {
                    writer.write(loadableModel.classFqn() + "." + loadableModel.fieldName() + "=" + Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".getSpecialModel(event," + Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".newRL(" + ModInit.quote(loadableModel.modelNamespace()) + "," + ModInit.quote(loadableModel.modelPath()) + "));");
                }
                writer.write("}");
            }
            if (!this.datagen.isEmpty()) {
                writer.write("private static void gatherData(" + Classes.sourceName("net.minecraftforge.data.event.GatherDataEvent") + " event){");
                for (DatagenEntry datagenEntry : this.datagen) {
                    String ctorArgs = datagenEntry.ctorArgs().stream().map(t -> switch (t) {
                        default -> throw new IncompatibleClassChangeError();
                        case DatagenEntry.Arg.MOD -> this.modClass.getSimpleName() + "$.mod";
                        case DatagenEntry.Arg.GENERATOR -> Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".getDataGenerator(event)";
                        case DatagenEntry.Arg.FILE_HELPER -> Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".getDataFileHelper(event)";
                    }).collect(Collectors.joining(","));
                    writer.write(Classes.sourceName("org.moddingx.libx.annotation.impl.ProcessorInterface") + ".addDataProvider(event,new " + datagenEntry.classFqn() + "(" + ctorArgs + "));");
                }
                writer.write("}");
            }
            writer.write("}\n");
            writer.close();
        }
        catch (IOException e2) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Failed to generate source code: " + e2, this.modClass);
        }
    }

    public static String quote(String str) {
        StringBuilder sb = new StringBuilder("\"");
        for (char chr : str.toCharArray()) {
            if (chr == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (chr == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (chr == '\'') {
                sb.append("\\'");
                continue;
            }
            if (chr == '\n') {
                sb.append("\\n");
                continue;
            }
            if (chr == '\r') {
                sb.append("\\r");
                continue;
            }
            if (chr == '\t') {
                sb.append("\\t");
                continue;
            }
            if (chr == '\b') {
                sb.append("\\b");
                continue;
            }
            if (chr <= '\u001f' || chr > '\u00ff') {
                sb.append(String.format("\\u%04d", chr));
                continue;
            }
            sb.append(chr);
        }
        sb.append("\"");
        return sb.toString();
    }
}

