/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.base.decoration;

import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.moddingx.libx.base.BlockBase;
import org.moddingx.libx.base.decoration.DecorationContext;
import org.moddingx.libx.base.decoration.DecorationType;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

public class DecoratedBlock
extends BlockBase {
    private final DecorationContext context;
    private final Map<DecorationType<?>, Object> elements;
    private final Map<String, Registerable> registerMap;

    public DecoratedBlock(ModX mod, DecorationContext context, BlockBehaviour.Properties properties) {
        this(mod, context, properties, new Item.Properties());
    }

    public DecoratedBlock(ModX mod, DecorationContext context, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, properties, itemProperties);
        this.context = context;
        DecorationContext.RegistrationInfo info = context.register(this.mod, this);
        this.elements = info.elementMap();
        this.registerMap = info.registerMap();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
        super.registerAdditional(ctx, builder);
        for (Map.Entry<String, Registerable> entry : this.registerMap.entrySet()) {
            builder.registerNamed(null, entry.getKey(), entry.getValue());
        }
    }

    public DecorationContext getContext() {
        return this.context;
    }

    public boolean has(DecorationType<?> type) {
        return this.context.has(type) && this.elements.containsKey(type);
    }

    @Nonnull
    public <T> T get(DecorationType<T> type) {
        if (type == DecorationType.BASE) {
            return (T)this;
        }
        if (this.has(type)) {
            return (T)this.elements.get(type);
        }
        throw new NoSuchElementException("Decoration context " + this.context + " has no element of type " + type.name() + ": " + type);
    }
}

