/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.moddingx.libx.LibX;
import org.moddingx.libx.impl.config.ConfigImpl;
import org.moddingx.libx.impl.config.ConfigState;
import org.moddingx.libx.network.PacketSerializer;

public class ConfigShadowSerializer
implements PacketSerializer<ConfigShadowMessage> {
    @Override
    public Class<ConfigShadowMessage> messageClass() {
        return ConfigShadowMessage.class;
    }

    @Override
    public void encode(ConfigShadowMessage msg, FriendlyByteBuf buffer) {
        buffer.m_130085_(msg.config.id);
        FriendlyByteBuf b = new FriendlyByteBuf(Unpooled.buffer());
        msg.state.write(b);
        buffer.m_130130_(b.writerIndex());
        buffer.writeBytes((ByteBuf)b);
    }

    @Override
    public ConfigShadowMessage decode(FriendlyByteBuf buffer) {
        ResourceLocation configId = buffer.m_130281_();
        ConfigImpl config = ConfigImpl.getConfigNullable(configId);
        int size = buffer.m_130242_();
        if (config == null) {
            LibX.logger.warn("Received shadow message for unknown config: '" + configId + "'. Ignoring");
            buffer.skipBytes(size);
            return new ConfigShadowMessage(null, null);
        }
        if (config.clientConfig) {
            LibX.logger.warn("Received shadow message for not-synced config: '" + configId + "'. Ignoring");
            buffer.skipBytes(size);
            return new ConfigShadowMessage(null, null);
        }
        return new ConfigShadowMessage(config, config.readState(buffer));
    }

    public record ConfigShadowMessage(ConfigImpl config, ConfigState state) {
    }
}

