/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.network;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.impl.network.BeRequestHandler;
import org.moddingx.libx.impl.network.BeRequestSerializer;
import org.moddingx.libx.impl.network.BeUpdateHandler;
import org.moddingx.libx.impl.network.BeUpdateSerializer;
import org.moddingx.libx.impl.network.ConfigShadowHandler;
import org.moddingx.libx.impl.network.ConfigShadowSerializer;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.network.NetworkX;

public final class NetworkImpl
extends NetworkX {
    private static NetworkImpl impl = null;

    public NetworkImpl(ModX mod) {
        super(mod);
        if (impl != null) {
            throw new IllegalStateException("NetworkImpl created twice.");
        }
        impl = this;
    }

    @Nonnull
    public static NetworkImpl getImpl() {
        if (impl == null) {
            throw new IllegalStateException("NetworkImpl not yet created.");
        }
        return impl;
    }

    @Override
    protected NetworkX.Protocol getProtocol() {
        return new NetworkX.Protocol("8", NetworkX.ProtocolSide.VANILLA, NetworkX.ProtocolSide.REQUIRED);
    }

    public boolean canSend() {
        return (Boolean)DistExecutor.unsafeRunForDist(() -> () -> Minecraft.m_91087_().m_91403_() != null && this.channel.isRemotePresent(Minecraft.m_91087_().m_91403_().m_6198_()), () -> () -> true);
    }

    @Override
    protected void registerPackets() {
        this.register(new BeUpdateSerializer(), () -> BeUpdateHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new ConfigShadowSerializer(), () -> ConfigShadowHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new BeRequestSerializer(), () -> BeRequestHandler::handle, NetworkDirection.PLAY_TO_SERVER);
    }

    public void updateBE(Level level, BlockPos pos) {
        if (!level.f_46443_ && this.canSend()) {
            this.updateBE(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), level, pos);
        }
    }

    void updateBE(PacketDistributor.PacketTarget target, Level level, BlockPos pos) {
        if (!level.f_46443_ && this.canSend()) {
            BlockEntity be = level.m_7702_(pos);
            if (be == null) {
                return;
            }
            CompoundTag nbt = be.m_5995_();
            if (nbt == null) {
                return;
            }
            ResourceLocation id = ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)be.m_58903_());
            if (id == null) {
                return;
            }
            this.channel.send(target, (Object)new BeUpdateSerializer.BeUpdateMessage(pos, id, nbt));
        }
    }

    public void requestBE(Level level, BlockPos pos) {
        if (level.f_46443_ && this.canSend()) {
            this.channel.sendToServer((Object)new BeRequestSerializer.BeRequestMessage(pos));
        }
    }
}

