/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.network;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.moddingx.libx.impl.ModInternal;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.network.PacketSerializer;

public abstract class NetworkX {
    private static final Object LOCK = new Object();
    public final SimpleChannel channel;
    private final Protocol protocol = this.getProtocol();
    private int discriminator = 0;

    public NetworkX(ModX mod) {
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)mod.resource("netchannel"), this.protocol::version, remote -> this.protocol.client().predicate.test(this.protocol.version(), (String)remote), remote -> this.protocol.server().predicate.test(this.protocol.version(), (String)remote));
        ModInternal.get(mod).addSetupTask(this::registerPackets, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void register(PacketSerializer<T> serializer, Supplier<BiConsumer<T, Supplier<NetworkEvent.Context>>> handler, NetworkDirection direction) {
        Object object = LOCK;
        synchronized (object) {
            Objects.requireNonNull(direction);
            BiConsumer<T, Supplier<NetworkEvent.Context>> realHandler = direction == NetworkDirection.PLAY_TO_CLIENT || direction == NetworkDirection.LOGIN_TO_CLIENT ? (BiConsumer<T, Supplier<NetworkEvent.Context>>)DistExecutor.unsafeRunForDist(() -> handler, () -> () -> (msg, ctx) -> {}) : handler.get();
            this.channel.registerMessage(this.discriminator++, serializer.messageClass(), serializer::encode, serializer::decode, realHandler, Optional.of(direction));
        }
    }

    protected abstract Protocol getProtocol();

    protected abstract void registerPackets();

    public record Protocol(String version, ProtocolSide client, ProtocolSide server) {
        public static Protocol of(String version) {
            return new Protocol(version, ProtocolSide.REQUIRED, ProtocolSide.REQUIRED);
        }
    }

    public static enum ProtocolSide {
        REQUIRED(String::equals),
        OPTIONAL(ProtocolSide.REQUIRED.predicate.or((version, remote) -> NetworkRegistry.ABSENT.equals(remote))),
        VANILLA(ProtocolSide.OPTIONAL.predicate.or((version, remote) -> NetworkRegistry.ACCEPTVANILLA.equals(remote))),
        REJECTED((version, remote) -> false);

        private final BiPredicate<String, String> predicate;

        private ProtocolSide(BiPredicate<String, String> predicate) {
            this.predicate = predicate;
        }
    }
}

