/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.registration;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class RegistrationContext {
    private final ResourceLocation id;
    private final Optional<ResourceKey<?>> key;
    private final Optional<ResourceKey<? extends Registry<?>>> registry;

    public RegistrationContext(ResourceLocation id, @Nullable ResourceKey<?> key) {
        this.id = id;
        this.key = Optional.ofNullable(key);
        this.registry = this.key.map(ResourceKey::m_211136_).map(ResourceKey::m_135788_);
        if (this.key.isPresent() && !Objects.equals(this.id, this.key.get().m_135782_())) {
            throw new IllegalArgumentException("Id does not match resource key: " + id + " " + key);
        }
    }

    public ResourceLocation id() {
        return this.id;
    }

    public Optional<ResourceKey<?>> key() {
        return this.key;
    }

    public Optional<ResourceKey<? extends Registry<?>>> registry() {
        return this.registry;
    }
}

