package org.moddingx.libx.block;

import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

import java.util.ArrayList;
import java.util.List;

/**
 * Holds 6 different {@link VoxelShape VoxelShapes}, one for each facing. Those are all created by rotating
 * one original VoxelShape.
 */
public class DirectionShape extends RotationShape {
    
    protected final VoxelShape up;
    protected final VoxelShape down;

    /**
     * Creates a new RotationShape with the given base shape. The base shape should be the shape
     * facing up.
     */
    public DirectionShape(VoxelShape baseShape) {
        super(rotatedV(baseShape));
        this.up = baseShape;
        this.down = rotatedV(this.north);
    }

    /**
     * @inheritDoc
     */
    @Override
    public VoxelShape getShape(Direction direction) {
        return switch (direction) {
            case UP -> this.up;
            case DOWN -> this.down;
            default -> super.getShape(direction);
        };
    }

    private static VoxelShape rotatedV(VoxelShape src) {
        List<VoxelShape> boxes = new ArrayList<>();
        src.m_83286_((fromX, fromY, fromZ, toX, toY, toZ) -> boxes.add(Shapes.m_83048_(
                Math.min(fromX, toX),
                Math.min(fromZ, toZ),
                Math.min(1 - fromY, 1 - toY),
                Math.max(fromX, toX),
                Math.max(fromZ, toZ),
                Math.max(1 - fromY, 1 - toY)
        )));
        return Shapes.m_83124_(Shapes.m_83040_(), boxes.toArray(new VoxelShape[]{})).m_83296_();
    }
}
