package org.moddingx.libx.creativetab;

import net.minecraft.world.item.ItemStack;
import org.moddingx.libx.base.BlockBase;
import org.moddingx.libx.base.ItemBase;

import java.util.stream.Stream;

/**
 * Can be implemented on items to provide custom logic on how {@link CreativeTabX} should fill them by default.
 * Both {@link ItemBase} and the block item generated by {@link BlockBase} implement this by default.
 */
public interface CreativeTabItemProvider {

    /**
     * Returns a {@link Stream} of {@link ItemStack item stacks} to add to a creative tab.
     */
    Stream<ItemStack> makeCreativeTabStacks();
}
