package org.moddingx.libx.datagen.provider.loot;

import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.provider.loot.entry.LootModifier;

import javax.annotation.Nullable;

public abstract class EntityLootProviderBase extends LootProviderBase<EntityType<?>> {

    protected EntityLootProviderBase(DatagenContext ctx) {
        super(ctx, "entities", LootContextParamSets.f_81415_, Registries.f_256939_);
    }

    @Nullable
    @Override
    protected LootTable.Builder defaultBehavior(EntityType<?> item) {
        return null;
    }
    
    /**
     * Gets a loot modifier for the looting enchantment.
     * 
     * @param max The maximum amount of additional drops.
     */
    public LootModifier<EntityType<?>> looting(int max) {
        return this.looting(0, max);
    }
    
    /**
     * Gets a loot modifier for the looting enchantment.
     * 
     * @param min The minimum amount of additional drops.
     * @param max The maximum amount of additional drops.
     */
    public LootModifier<EntityType<?>> looting(int min, int max) {
        return this.modifier((entity, entry) -> entry.m_79078_(LootingEnchantFunction.m_165229_(UniformGenerator.m_165780_(min, max))));
    }

    /**
     * Gets a loot condition that checks, whether the killed entity was on fire. 
     */
    public LootItemCondition.Builder fire() {
        return LootItemEntityPropertyCondition.m_81864_(LootContext.EntityTarget.THIS, EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(true).m_33716_()));
    }
    
    /**
     * Gets a loot modifier that smelts the item, if the killed entity was on fire.
     */
    public LootModifier<EntityType<?>> smeltOnFire() {
        return this.modifier((entity, entry) -> entry.m_79078_(SmeltItemFunction.m_81271_().m_79080_(this.fire())));
    }
}
