package org.moddingx.libx.datagen.provider.recipe.crafting;

import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.world.level.ItemLike;
import org.moddingx.libx.datagen.provider.recipe.RecipeExtension;

/**
 * A {@link RecipeExtension} with default methods for compressing things.
 */
public interface CompressionExtension extends RecipeExtension {

    default void compress(ItemLike item, ItemLike compressed) {
        this.compress(RecipeCategory.MISC, item, compressed);
    }

    default void compress(ItemLike item, ItemLike compressed, boolean canRevert) {
        this.compress(RecipeCategory.MISC, item, compressed, canRevert);
    }

    default void compress(RecipeCategory recipeCategory, ItemLike item, ItemLike compressed) {
        this.compress(recipeCategory, item, compressed, true);
    }
    
    default void compress(RecipeCategory recipeCategory, ItemLike item, ItemLike compressed, boolean canRevert) {
        ShapedRecipeBuilder.m_245327_(recipeCategory, compressed)
                .m_126127_('a', item)
                .m_126130_("aaa")
                .m_126130_("aaa")
                .m_126130_("aaa")
                .m_126132_("has_item", this.criterion(item))
                .m_126140_(this.consumer(), this.provider().loc(item, "compress"));

        if (canRevert) {
            ShapelessRecipeBuilder.m_246517_(recipeCategory, item, 9)
                    .m_126209_(compressed)
                    .m_126132_("has_item", this.criterion(compressed))
                    .m_126140_(this.consumer(), this.provider().loc(compressed, "decompress"));
        }
    }

    default void smallCompress(ItemLike item, ItemLike compressed) {
        this.smallCompress(RecipeCategory.MISC, item, compressed);
    }

    default void smallCompress(ItemLike item, ItemLike compressed, boolean canRevert) {
        this.smallCompress(RecipeCategory.MISC, item, compressed, canRevert);
    }

    default void smallCompress(RecipeCategory recipeCategory, ItemLike item, ItemLike compressed) {
        this.smallCompress(recipeCategory, item, compressed, true);
    }
    
    default void smallCompress(RecipeCategory recipeCategory, ItemLike item, ItemLike compressed, boolean canRevert) {
        ShapedRecipeBuilder.m_245327_(recipeCategory, compressed)
                .m_126127_('a', item)
                .m_126130_("aa")
                .m_126130_("aa")
                .m_126132_("has_item", this.criterion(item))
                .m_126140_(this.consumer(), this.provider().loc(item, "small_compress"));

        if (canRevert) {
            ShapelessRecipeBuilder.m_246517_(recipeCategory, item, 4)
                    .m_126209_(compressed)
                    .m_126132_("has_item", this.criterion(compressed))
                    .m_126140_(this.consumer(), this.provider().loc(compressed, "small_decompress"));
        }
    }

    default void doubleCompress(ItemLike item, ItemLike compressed, ItemLike doubleCompressed) {
        this.doubleCompress(item, compressed, doubleCompressed, true);
    }

    default void doubleCompress(ItemLike item, ItemLike compressed, ItemLike doubleCompressed, boolean canRevert) {
        this.compress(item, compressed, canRevert);
        this.compress(compressed, doubleCompressed, canRevert);
    }
}
