package org.moddingx.libx.datagen.provider.recipe.crafting;

import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.datagen.provider.recipe.RecipeExtension;

import javax.annotation.Nullable;
import java.util.Objects;

/**
 * A {@link RecipeExtension} that adds the ability to add common tool recipes easily.
 */
public interface ToolExtension extends RecipeExtension {

    /**
     * Creates tool recipes for a material. All the tool items may be null in which case the recipe is not created.
     */
    default void makeTools(ItemLike material, @Nullable ItemLike sword, @Nullable ItemLike axe,
                           @Nullable ItemLike pick, @Nullable ItemLike shovel, @Nullable ItemLike hoe) {

        if (sword != null) {
            ShapedRecipeBuilder.m_245327_(RecipeCategory.COMBAT, sword)
                    .m_126127_('m', material)
                    .m_206416_('s', Tags.Items.RODS_WOODEN)
                    .m_126130_("m")
                    .m_126130_("m")
                    .m_126130_("s")
                    .m_126145_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(material.m_5456_())) + "_sword")
                    .m_126132_("has_item0", this.criterion(Tags.Items.RODS_WOODEN))
                    .m_126132_("has_item1", this.criterion(material))
                    .m_126140_(this.consumer(), this.provider().loc(material, "sword"));
        }

        if (axe != null) {
            ShapedRecipeBuilder.m_245327_(RecipeCategory.TOOLS, axe)
                    .m_126127_('m', material)
                    .m_206416_('s', Tags.Items.RODS_WOODEN)
                    .m_126130_("mm")
                    .m_126130_("sm")
                    .m_126130_("s ")
                    .m_126145_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(material.m_5456_())) + "_axe")
                    .m_126132_("has_item0", this.criterion(Tags.Items.RODS_WOODEN))
                    .m_126132_("has_item1", this.criterion(material))
                    .m_126140_(this.consumer(), this.provider().loc(material, "axe"));
        }

        if (pick != null) {
            ShapedRecipeBuilder.m_245327_(RecipeCategory.TOOLS, pick)
                    .m_126127_('m', material)
                    .m_206416_('s', Tags.Items.RODS_WOODEN)
                    .m_126130_("mmm")
                    .m_126130_(" s ")
                    .m_126130_(" s ")
                    .m_126145_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(material.m_5456_())) + "_pick")
                    .m_126132_("has_item0", this.criterion(Tags.Items.RODS_WOODEN))
                    .m_126132_("has_item1", this.criterion(material))
                    .m_126140_(this.consumer(), this.provider().loc(material, "pick"));
        }

        if (shovel != null) {
            ShapedRecipeBuilder.m_245327_(RecipeCategory.TOOLS, shovel)
                    .m_126127_('m', material)
                    .m_206416_('s', Tags.Items.RODS_WOODEN)
                    .m_126130_("m")
                    .m_126130_("s")
                    .m_126130_("s")
                    .m_126145_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(material.m_5456_())) + "_shovel")
                    .m_126132_("has_item0", this.criterion(Tags.Items.RODS_WOODEN))
                    .m_126132_("has_item1", this.criterion(material))
                    .m_126140_(this.consumer(), this.provider().loc(material, "shovel"));
        }

        if (hoe != null) {
            ShapedRecipeBuilder.m_245327_(RecipeCategory.TOOLS, hoe)
                    .m_126127_('m', material)
                    .m_206416_('s', Tags.Items.RODS_WOODEN)
                    .m_126130_("mm")
                    .m_126130_("s ")
                    .m_126130_("s ")
                    .m_126145_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(material.m_5456_())) + "_hoe")
                    .m_126132_("has_item0", this.criterion(Tags.Items.RODS_WOODEN))
                    .m_126132_("has_item1", this.criterion(material))
                    .m_126140_(this.consumer(), this.provider().loc(material, "hoe"));
        }
    }

    /**
     * Creates armor recipes for a material. All the armor items may be null in which case the recipe is not created.
     */
    default void makeArmor(ItemLike material, @Nullable ItemLike helmet, @Nullable ItemLike chestplate,
                           @Nullable ItemLike leggings, @Nullable ItemLike boots) {

        if (helmet != null) {
            ShapedRecipeBuilder.m_245327_(RecipeCategory.COMBAT, helmet)
                    .m_126127_('m', material)
                    .m_126130_("mmm")
                    .m_126130_("m m")
                    .m_126145_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(material.m_5456_())) + "_helmet")
                    .m_126132_("has_item", this.criterion(material))
                    .m_126140_(this.consumer(), this.provider().loc(material.m_5456_(), "helmet"));
        }

        if (chestplate != null) {
            ShapedRecipeBuilder.m_245327_(RecipeCategory.COMBAT, chestplate)
                    .m_126127_('m', material)
                    .m_126130_("m m")
                    .m_126130_("mmm")
                    .m_126130_("mmm")
                    .m_126145_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(material.m_5456_())) + "_chestplate")
                    .m_126132_("has_item", this.criterion(material))
                    .m_126140_(this.consumer(), this.provider().loc(material.m_5456_(), "chestplate"));
        }

        if (leggings != null) {
            ShapedRecipeBuilder.m_245327_(RecipeCategory.COMBAT, leggings)
                    .m_126127_('m', material)
                    .m_126130_("mmm")
                    .m_126130_("m m")
                    .m_126130_("m m")
                    .m_126145_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(material.m_5456_())) + "_leggings")
                    .m_126132_("has_item", this.criterion(material))
                    .m_126140_(this.consumer(), this.provider().loc(material.m_5456_(), "leggings"));
        }

        if (boots != null) {
            ShapedRecipeBuilder.m_245327_(RecipeCategory.COMBAT, boots)
                    .m_126127_('m', material)
                    .m_126130_("m m")
                    .m_126130_("m m")
                    .m_126145_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(material.m_5456_())) + "_boots")
                    .m_126132_("has_item", this.criterion(material))
                    .m_126140_(this.consumer(), this.provider().loc(material.m_5456_(), "boots"));
        }
    }
}
