package org.moddingx.libx.impl.base.decoration;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.moddingx.libx.base.decoration.DecorationMaterial;

import java.util.function.Function;

import org.moddingx.libx.base.decoration.DecorationMaterial.MaterialProperties;

public record BaseMaterial(boolean isWood, boolean isStone, boolean isMetal, Function<ResourceLocation, DecorationMaterial.MaterialProperties> factory) implements DecorationMaterial {

    public static final BaseMaterial GENERIC = new BaseMaterial(false, false, false, id -> new DecorationMaterial.MaterialProperties(null, null));
    
    public static final BaseMaterial WOOD = new BaseMaterial(true, false, false, id -> {
        BlockSetType setType = new BlockSetType(id.toString(), true, SoundType.f_56736_, SoundEvents.f_12626_, SoundEvents.f_12627_, SoundEvents.f_12628_, SoundEvents.f_12629_, SoundEvents.f_12636_, SoundEvents.f_12637_, SoundEvents.f_12631_, SoundEvents.f_12632_);
        WoodType woodType = new WoodType(id.toString(), setType, SoundType.f_56736_, SoundType.f_244174_, SoundEvents.f_11872_, SoundEvents.f_11873_);
        return new DecorationMaterial.MaterialProperties(setType, woodType);
    });
    
    public static final BaseMaterial STONE = new BaseMaterial(false, true, false, id -> {
        BlockSetType setType = new BlockSetType(id.toString(), false, SoundType.f_56742_, SoundEvents.f_12055_, SoundEvents.f_12056_, SoundEvents.f_12011_, SoundEvents.f_12012_, SoundEvents.f_12448_, SoundEvents.f_12449_, SoundEvents.f_12443_, SoundEvents.f_12444_);
        return new DecorationMaterial.MaterialProperties(setType, null);
    });
    
    public static final BaseMaterial METAL = new BaseMaterial(false, true, true, id -> {
        BlockSetType setType = new BlockSetType(id.toString(), false, SoundType.f_56743_, SoundEvents.f_12055_, SoundEvents.f_12056_, SoundEvents.f_12011_, SoundEvents.f_12012_, SoundEvents.f_12066_, SoundEvents.f_12067_, SoundEvents.f_12443_, SoundEvents.f_12444_);
        return new DecorationMaterial.MaterialProperties(setType, null);
    });

    @Override
    public MaterialProperties init(ResourceLocation id) {
        return this.factory.apply(id);
    }
}
