package org.moddingx.libx.impl.base.decoration.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.moddingx.libx.base.decoration.DecoratedBlock;
import org.moddingx.libx.registration.Registerable;

import javax.annotation.Nonnull;

import net.minecraft.world.level.block.state.BlockBehaviour.Properties;

public class DecoratedDoorBlock extends DoorBlock implements Registerable {

    public final DecoratedBlock parent;

    public DecoratedDoorBlock(DecoratedBlock parent) {
        super(Properties.m_60926_(parent), parent.getMaterialProperties().blockSetType());
        this.parent = parent;
    }

    @Override
    public void m_214162_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        this.parent.m_214162_(state, level, pos, random);
    }

    @Override
    @SuppressWarnings("deprecation")
    public float m_7325_() {
        return this.parent.m_7325_();
    }

    @Override
    @SuppressWarnings("deprecation")
    public int m_7753_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return this.parent.m_7753_(state, level, pos);
    }

    @Override
    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return this.parent.getLightEmission(state, world, pos);
    }
}
