package org.moddingx.libx.impl.commands.common;

import com.google.common.base.Suppliers;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

import java.util.List;
import java.util.UUID;

/**
 * As the "new" /data merge entity command can only merge data to one entity at a time and you always have to
 * prefix ist with a /execute here's a version that can merge data into multiple entities at once.
 * This command can also merge data into players. Be careful with this.
 */
public class EntityDataCommand implements Command<CommandSourceStack> {

    @Override
    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        EntitySelector sel = context.getArgument("entities", EntitySelector.class);
        List<? extends Entity> entities = sel.m_121160_(context.getSource());
        CompoundTag nbt = context.getArgument("nbt", CompoundTag.class);
        boolean players = false;
        for (Entity entity : entities) {
            if (entity instanceof Player) {
                if (!context.getSource().m_6761_(4)) {
                    throw new SimpleCommandExceptionType(Component.m_237115_("libx.command.entitydata.player_modify_no_permission")).create();
                } else {
                    players = true;
                }
            }
        }
        
        for (Entity entity : entities) {
            UUID uid = entity.m_20148_();
            CompoundTag entityNBT = entity.m_20240_(new CompoundTag());
            entityNBT.m_128391_(nbt);
            entity.m_20258_(entityNBT);
            entity.m_20084_(uid);
        }
        context.getSource().m_288197_(Suppliers.ofInstance(Component.m_237110_(players ? "libx.command.entitydata.modified_player" : "libx.command.entitydata.modified", entities.size())), true);
        
        return 0;
    }
}
