package org.moddingx.libx.impl.commands.common;

import com.google.common.base.Suppliers;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.command.CommandUtil;
import org.moddingx.libx.util.game.ComponentUtil;

import java.util.List;
import java.util.Objects;

// Not a client command as the client does not have the full stack tag
public class HandCommand implements Command<CommandSourceStack> {

    @Override
    public int run(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ctx.getSource().m_81375_();
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);

        Item item;
        int count;
        CompoundTag nbt;

        if (stack.m_41619_() || ForgeRegistries.ITEMS.getKey(stack.m_41720_()) == null) {
            item = Items.f_41852_;
            count = 0;
            nbt = null;
        } else {
            item = stack.m_41720_();
            count = stack.m_41613_();
            nbt = stack.m_41783_();
        }

        NbtPathArgument.NbtPath path = CommandUtil.getArgumentOrDefault(ctx, "nbt_path", NbtPathArgument.NbtPath.class, null);

        ResourceLocation id = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item));
        MutableComponent message = ComponentUtil.withCopyAction(Component.m_237113_(id.toString()), id.toString()).m_6881_();

        if (count != 1) {
            message = message.m_7220_(Component.m_237113_(" ")).m_7220_(Component.m_237113_(Integer.toString(count)));
        }

        if (nbt != null && !nbt.m_128456_()) {
            List<Tag> printNBT = path == null ? List.of(nbt) : path.m_99638_(nbt);
            for (Tag element : printNBT) {
                message = message.m_7220_(Component.m_237113_(" ")).m_7220_(ComponentUtil.withCopyAction(NbtUtils.m_178061_(element), element.toString()));
            }
        }

        ctx.getSource().m_288197_(Suppliers.ofInstance(message), true);

        return 0;
    }
}
