package org.moddingx.libx.impl.config.gui.editor;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.InputProperties;
import org.moddingx.libx.config.gui.WidgetProperties;
import org.moddingx.libx.config.validator.ValidatorInfo;
import org.moddingx.libx.render.RenderHelper;

import javax.annotation.Nonnull;
import java.util.Optional;

public class InputEditor<T> implements ConfigEditor<T> {

    private final InputProperties<T> properties;
    private final ValidatorInfo<?> validator;

    public InputEditor(InputProperties<T> properties, ValidatorInfo<?> validator) {
        this.properties = properties;
        this.validator = validator;
    }

    @Override
    public T defaultValue() {
        return this.properties.defaultValue();
    }

    @Override
    public AbstractWidget createWidget(Screen screen, T initialValue, WidgetProperties<T> properties) {
        return new InputWidget<>(this.properties, this.validator, initialValue, properties);
    }

    @Override
    public AbstractWidget updateWidget(Screen screen, AbstractWidget old, WidgetProperties<T> properties) {
        if (old instanceof InputWidget) {
            //noinspection unchecked
            return new InputWidget<>(this.properties, this.validator, (InputWidget<T>) old, properties);
        } else {
            return this.createWidget(screen, this.defaultValue(), properties);
        }
    }

    public static class InputWidget<T> extends EditBox {

        private final InputProperties<T> input;
        private final ValidatorInfo<?> validator;
        private String last = null;

        private InputWidget(InputProperties<T> input, ValidatorInfo<?> validator, WidgetProperties<T> properties, String initialValue) {
            super(Minecraft.m_91087_().f_91062_, properties.x(), properties.y(), properties.width(), properties.height(), Component.m_237119_());
            this.input = input;
            this.validator = validator;
            this.m_94199_(32767);
            this.m_94144_(initialValue);
            this.m_94153_(str -> {
                for (char chr : str.toCharArray()) {
                    if (!this.input.canInputChar(chr)) {
                        return false;
                    }
                }
                return true;
            });
            this.m_94151_(str -> {
                if (this.last == null || !this.last.equals(str)) {
                    this.last = str;
                    if (this.input.isValid(str)) {
                        // No need to check validator here, will be validated when saving
                        properties.inputChanged().accept(this.input.valueOf(str));
                    }
                }
            });
        }

        public InputWidget(InputProperties<T> input, ValidatorInfo<?> validator, T initialValue, WidgetProperties<T> properties) {
            this(input, validator, properties, input.toString(initialValue));
        }

        public InputWidget(InputProperties<T> input, ValidatorInfo<?> validator, InputWidget<T> old, WidgetProperties<T> properties) {
            this(input, validator, properties, old.m_94155_());
        }

        // Used internally by other config editors
        // may not check `last`
        public Optional<T> getValidInput() {
            return this.getValidInput(this.m_94155_());
        }
        
        private Optional<T> getValidInput(String str) {
            if (this.input.isValid(str)) {
                T t = this.input.valueOf(str);
                if (this.validator.isValid(t)) {
                    return Optional.of(t);
                }
            }
            return Optional.empty();
        }

        @Override
        public void m_87963_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.m_87963_(graphics, mouseX, mouseY, partialTicks);
            if (this.m_94213_() && this.getValidInput(this.m_94155_()).isEmpty()) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(0, 0, 10);
                RenderHelper.rgb(0xFF2222);
                graphics.m_280163_(RenderHelper.TEXTURE_WHITE, this.m_252754_() - 1, this.m_252907_() - 1, 0, 0, this.f_93618_ + 2, 1, 256, 256);
                graphics.m_280163_(RenderHelper.TEXTURE_WHITE, this.m_252754_() - 1, this.m_252907_() + this.f_93619_, 0, 0, this.f_93618_ + 2, 1, 256, 256);
                graphics.m_280163_(RenderHelper.TEXTURE_WHITE, this.m_252754_() - 1, this.m_252907_() - 1, 0, 0, 1, this.f_93619_ + 2, 256, 256);
                graphics.m_280163_(RenderHelper.TEXTURE_WHITE, this.m_252754_() + this.f_93618_, this.m_252907_() - 1, 0, 0, 1, this.f_93619_ + 2, 256, 256);
                RenderHelper.resetColor();
                graphics.m_280168_().m_85849_();
            }
        }
    }
}
