package org.moddingx.libx.impl.config.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;
import org.moddingx.libx.render.FilterGuiGraphics;
import org.moddingx.libx.render.RenderHelper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

import net.minecraft.client.gui.narration.NarratableEntry.NarrationPriority;

public abstract class ConfigBaseScreen extends Screen {

    protected final Minecraft mc;

    @Nullable
    private final ConfigScreenManager manager;
    private final boolean hasSearchBar;

    @Nullable
    private EditBox searchBar;
    
    @Nullable
    private BasePanel panel;
    
    // While rendering the scrollable view, tooltips must be delayed
    // Because clipping is enabled, and they need to be rendered with
    // absolute coordinates as they should not be cut by the screen border.
    private final List<Pair<Matrix4f, Consumer<GuiGraphics>>> capturedTooltips = new LinkedList<>();
    private boolean isCapturingTooltips = false;
    private int currentScrollOffset = 0;

    protected ConfigBaseScreen(Component title, @Nullable ConfigScreenManager manager, boolean hasSearchBar) {
        super(title);
        this.mc = Minecraft.m_91087_();
        this.manager = manager;
        this.hasSearchBar = hasSearchBar;
    }
    
    public int contentWidth() {
        return this.f_96543_ - 12;
    }

    @Override
    protected void m_7856_() {
        if (this.manager != null) {
            Button back = Button.m_253074_(Component.m_237113_("\u2190 ").m_7220_(Component.m_237115_("libx.config.gui.back")), button -> this.manager.close())
                    .m_252794_(5, 5)
                    .m_253046_(52, 20)
                    .m_253136_();
            this.m_142416_(back);
        }

        if (this.hasSearchBar) {
            boolean shouldFocus = this.searchBar != null && this.searchBar.m_93696_();
            boolean isActive = this.searchBar != null && this.m_7222_() == this.searchBar;
            this.searchBar = new EditBox(this.mc.f_91062_, 20, 18 + this.mc.f_91062_.f_92710_, this.f_96543_ - 40, 20, this.searchBar, Component.m_237115_("libx.config.gui.search.title"));
            this.searchBar.m_94199_(32767);
            this.searchBar.m_93692_(shouldFocus);
            this.m_142416_(this.searchBar);
            if (isActive) {
                this.m_7522_(this.searchBar);
            }
            // Responder must be set last, or we'll trigger it while configuring the search bar
            this.searchBar.m_94151_(this::searchChange);
        } else {
            this.searchBar = null;
        }

        this.rebuild();
    }

    protected void rebuild() {
        if (this.panel != null) {
            this.m_169411_(this.panel);
        }
        
        ImmutableList.Builder<AbstractWidget> widgetBuilder = ImmutableList.builder();
        this.buildGui(widgetBuilder::add);
        List<AbstractWidget> widgets = widgetBuilder.build();

        int totalHeight = 10 + widgets.stream().map(w -> w.m_252907_() + w.m_93694_()).max(Comparator.naturalOrder()).orElse(0);
        int paddingTop = 18 + this.mc.f_91062_.f_92710_ + (this.hasSearchBar ? 26 : 0);

        this.panel = new BasePanel(this.mc, this.f_96543_ - 2, this.f_96544_ - paddingTop, paddingTop, 1) {

            @Override
            protected int getContentHeight() {
                return totalHeight;
            }

            @Override
            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                ConfigBaseScreen.this.isCapturingTooltips = true;
                graphics.m_280168_().m_85836_();
                super.m_88315_(new TooltipCapturingGuiGraphics(graphics), mouseX, mouseY, partialTicks);
                graphics.m_280168_().m_85849_();
                ConfigBaseScreen.this.isCapturingTooltips = false;
                ConfigBaseScreen.this.capturedTooltips.forEach(pair -> {
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_166856_();
                    graphics.m_280168_().m_252931_(pair.getLeft());
                    pair.getRight().accept(graphics);
                    graphics.m_280168_().m_85849_();
                });
                ConfigBaseScreen.this.capturedTooltips.clear();
            }

            @Override
            protected void drawPanel(GuiGraphics graphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
                ConfigBaseScreen.this.currentScrollOffset = relativeY;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(0, relativeY, 0);
                for (AbstractWidget widget : widgets) {
                    widget.m_88315_(graphics, mouseX, mouseY - relativeY, ConfigBaseScreen.this.mc.m_91297_());
                }
                graphics.m_280168_().m_85849_();
                ConfigBaseScreen.this.currentScrollOffset = 0;
            }

            @Override
            public boolean m_6375_(double mouseX, double mouseY, int button) {
                // Without this, the panel would process clicks from areas currently not on the screen
                if (mouseX >= this.left && mouseX <= this.left + this.width && mouseY >= this.top && mouseY <= this.top + this.height) {
                    return super.m_6375_(mouseX, mouseY, button);
                } else {
                    return false;
                }
            }

            @Override
            protected boolean clickPanel(double mouseX, double mouseY, int button) {
                // Extra var required as we need to cal all listeners
                // so widgets can for example handle their loss of focus.
                boolean success = false;
                for (GuiEventListener widget : widgets) {
                    if (widget.m_6375_(mouseX, mouseY, button)) {
                        this.m_7522_(widget);
                        if (button == 0) {
                            this.m_7897_(true);
                        }
                        success = true;
                    }
                }
                return success;
            }

            @Override
            public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
                if (!super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
                    if (this.m_7222_() != null && this.m_7282_() && button == 0) {
                        return this.m_7222_().m_7979_(mouseX, mouseY - this.top + ((int) this.scrollDistance) - this.border, button, dragX, dragY);
                    } else {
                        return false;
                    }
                } else {
                    return true;
                }
            }

            @Override
            public boolean m_6348_(double mouseX, double mouseY, int button) {
                if (!super.m_6348_(mouseX, mouseY, button)) {
                    if (this.m_7222_() != null) {
                        return this.m_7222_().m_6348_(mouseX, mouseY - this.top + ((int) this.scrollDistance) - this.border, button);
                    } else {
                        return false;
                    }
                } else {
                    return true;
                }
            }
        };
        this.m_142416_(this.panel);
    }

    protected abstract void buildGui(Consumer<AbstractWidget> consumer);

    @Nullable
    public ConfigScreenManager getCurrentManager() {
        return this.manager;
    }

    @Override
    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280039_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        RenderHelper.resetColor();
        graphics.m_280614_(this.f_96547_, this.m_96636_(), (this.f_96543_ - this.mc.f_91062_.m_92852_(this.m_96636_())) / 2, 11, 0xFFFFFF, true);
    }

    @Override
    public boolean m_7933_(int key, int i1, int i2) {
        if (key == GLFW.GLFW_KEY_ESCAPE && this.m_6913_() && this.manager != null) {
            this.manager.close();
            return true;
        } else {
            return super.m_7933_(key, i1, i2);
        }
    }

    public String searchTerm() {
        return this.searchBar == null ? "" : this.searchBar.m_94155_();
    }
    
    protected void searchChange(String term) {
        
    }

    private static abstract class BasePanel extends ScrollPanel implements NarratableEntry {

        public BasePanel(Minecraft mc, int width, int height, int top, int left) {
            super(mc, width, height, top, left);
        }

        @Nonnull
        @Override
        public NarrationPriority m_142684_() {
            return NarrationPriority.NONE;
        }

        @Override
        public void m_142291_(@Nonnull NarrationElementOutput output) {
            //
        }
    }

    private void captureTooltip(PoseStack.Pose pose, BiConsumer<GuiGraphics, Integer> action) {
        final int theOffset = this.currentScrollOffset;
        Matrix4f matrix = new Matrix4f(pose.m_252922_());
        matrix.translate(0, -theOffset, 0);
        this.capturedTooltips.add(Pair.of(matrix, poseStack -> action.accept(poseStack, theOffset)));
    }
    
    private class TooltipCapturingGuiGraphics extends FilterGuiGraphics {
        
        public TooltipCapturingGuiGraphics(GuiGraphics parent) {
            super(parent);
        }

        @Override
        public void m_280153_(@Nonnull Font font, @Nonnull ItemStack stack, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.m_280153_(font, stack, x, y + scrollOffset));
            } else {
                super.m_280153_(font, stack, x, y);
            }
        }

        @Override
        public void renderTooltip(@Nonnull Font font, @Nonnull List<Component> text, @Nonnull Optional<TooltipComponent> component, @Nonnull ItemStack stack, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.renderTooltip(font, text, component, stack, x, y + scrollOffset));
            } else {
                super.renderTooltip(font, text, component, stack, x, y);
            }
        }

        @Override
        public void m_280677_(@Nonnull Font font, @Nonnull List<Component> text, @Nonnull Optional<TooltipComponent> component, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.m_280677_(font, text, component, x, y + scrollOffset));
            } else {
                super.m_280677_(font, text, component, x, y);
            }
        }

        @Override
        public void m_280557_(@Nonnull Font font, @Nonnull Component text, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.m_280557_(font, text, x, y + scrollOffset));
            } else {
                super.m_280557_(font, text, x, y);
            }
        }

        @Override
        public void m_280666_(@Nonnull Font font, @Nonnull List<Component> text, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.m_280666_(font, text, x, y + scrollOffset));
            } else {
                super.m_280666_(font, text, x, y);
            }
        }

        @Override
        public void renderComponentTooltip(@Nonnull Font font, @Nonnull List<? extends FormattedText> text, int x, int y, @Nonnull ItemStack stack) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.renderComponentTooltip(font, text, x, y + scrollOffset, stack));
            } else {
                super.renderComponentTooltip(font, text, x, y, stack);
            }
        }

        @Override
        public void m_280245_(@Nonnull Font font, @Nonnull List<? extends FormattedCharSequence> text, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.m_280245_(font, text, x, y + scrollOffset));
            } else {
                super.m_280245_(font, text, x, y);
            }
        }

        @Override
        public void m_280547_(@Nonnull Font font, @Nonnull List<FormattedCharSequence> text, @Nonnull ClientTooltipPositioner positioner, int x, int y) {
            if (ConfigBaseScreen.this.isCapturingTooltips) {
                ConfigBaseScreen.this.captureTooltip(this.m_280168_().m_85850_(), (graphics, scrollOffset) -> graphics.m_280547_(font, text, positioner, x, y + scrollOffset));
            } else {
                super.m_280547_(font, text, positioner, x, y);
            }
        }
    }
}
