package org.moddingx.libx.impl.config.gui.screen.content.component.type;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.KeybindContents;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.ConfigScreenContent;
import org.moddingx.libx.config.gui.WidgetProperties;
import org.moddingx.libx.impl.config.gui.EditorHelper;
import org.moddingx.libx.impl.config.gui.screen.content.component.ComponentType;
import org.moddingx.libx.util.lazy.CachedValue;

import javax.annotation.Nullable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class KeybindComponentType implements ComponentType {

    // Keybinds may change so we only make it a cached value
    // that can be updated when required
    private final CachedValue<ConfigEditor<String>> keyEditor;

    private String key = "";
    private AbstractWidget keyWidget;

    private Consumer<MutableComponent> inputChanged;

    public KeybindComponentType() {
        this.keyEditor = new CachedValue<>(() -> ConfigEditor.toggle(KeyMapping.f_90809_.keySet().stream().sorted().toList()));
    }

    @Override
    public Component name() {
        return Component.m_237115_("libx.config.gui.component.type_key");
    }

    @Override
    public MutableComponent defaultValue() {
        if (KeyMapping.f_90809_.isEmpty()) {
            return Component.m_237117_("");
        } else {
            return Component.m_237117_(KeyMapping.f_90809_.keySet().stream().sorted().findFirst().get());
        }
    }

    @Nullable
    @Override
    public MutableComponent init(Component component, Consumer<MutableComponent> inputChanged) {
        this.inputChanged = inputChanged;
        if (component.m_214077_() instanceof KeybindContents kc) {
            this.key = kc.m_237348_();
            this.keyEditor.invalidate();
            return component.m_6879_();
        } else {
            return null;
        }
    }

    @Override
    public void buildGui(Screen screen, ConfigScreenContent.ScreenManager manager, AtomicInteger y, Consumer<AbstractWidget> consumer) {
        WidgetProperties<String> properties = new WidgetProperties<>(5, y.get(), manager.contentWidth() - 10, 20, key -> {
            this.key = key;
            if (this.inputChanged != null) {
                this.inputChanged.accept(Component.m_237117_(key));
            }
        });
        this.keyWidget = EditorHelper.create(screen, this.keyEditor.get(), this.key, this.keyWidget, properties);
        consumer.accept(this.keyWidget);
        y.addAndGet(23);
    }
}
