package org.moddingx.libx.impl.config.gui.screen.content.component.type;

import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.ConfigScreenContent;
import org.moddingx.libx.config.gui.WidgetProperties;
import org.moddingx.libx.impl.config.gui.EditorHelper;
import org.moddingx.libx.impl.config.gui.screen.content.component.ComponentType;

import javax.annotation.Nullable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class TextComponentType implements ComponentType {

    private final ConfigEditor<String> editor;

    private String value = "";
    private AbstractWidget widget;

    private Consumer<MutableComponent> inputChanged;

    public TextComponentType() {
        this.editor = ConfigEditor.input();
    }

    @Override
    public Component name() {
        return Component.m_237115_("libx.config.gui.component.type_text");
    }

    @Override
    public MutableComponent defaultValue() {
        return Component.m_237113_("");
    }

    @Nullable
    @Override
    public MutableComponent init(Component component, Consumer<MutableComponent> inputChanged) {
        this.inputChanged = inputChanged;
        if (component.m_214077_() == ComponentContents.f_237124_) {
            this.value = "";
            return component.m_6879_();
        } else if (component.m_214077_() instanceof LiteralContents lc) {
            this.value = lc.f_237368_();
            return component.m_6879_();
        } else {
            return null;
        }
    }

    @Override
    public void buildGui(Screen screen, ConfigScreenContent.ScreenManager manager, AtomicInteger y, Consumer<AbstractWidget> consumer) {
        WidgetProperties<String> properties = new WidgetProperties<>(5, y.get(), manager.contentWidth() - 10, 20, value -> {
            this.value = value;
            if (this.inputChanged != null) {
                this.inputChanged.accept(Component.m_237113_(value));
            }
        });
        this.widget = EditorHelper.create(screen, this.editor, this.value, this.widget, properties);
        consumer.accept(this.widget);
        y.addAndGet(23);
    }
}
