package org.moddingx.libx.impl.crafting.recipe;

import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.moddingx.libx.LibX;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EmptyRecipe implements Recipe<Container> {
    
    public static final ResourceLocation ID = LibX.getInstance().resource("empty");
    public static final RecipeType<EmptyRecipe> TYPE = RecipeType.simple(ID);
    
    private final ResourceLocation id;

    public EmptyRecipe(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public boolean m_5818_(@Nonnull Container inv, @Nonnull Level level) {
        return false;
    }

    @Nonnull
    @Override
    public ItemStack m_5874_(@Nonnull Container inv, @Nonnull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    @Override
    public ItemStack m_8043_(@Nonnull RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    @Override
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    @Override
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    @Override
    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    @Nonnull
    @Override
    public NonNullList<ItemStack> m_7457_(@Nonnull Container inv) {
        return NonNullList.m_122780_(inv.m_6643_(), ItemStack.f_41583_);
    }

    @Nonnull
    @Override
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122779_();
    }

    @Override
    public boolean m_5598_() {
        return false;
    }
    
    @Nonnull
    @Override
    public ItemStack m_8042_() {
        return new ItemStack(Blocks.f_50375_);
    }
    
    public static class Serializer implements RecipeSerializer<EmptyRecipe> {

        public static final Serializer INSTANCE = new Serializer();
        
        private Serializer() {
            
        }
        
        @Nonnull
        @Override
        public EmptyRecipe m_6729_(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            return new EmptyRecipe(recipeId);
        }

        @Nullable
        @Override
        public EmptyRecipe m_8005_(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            return new EmptyRecipe(recipeId);
        }

        @Override
        public void m_6178_(@Nonnull FriendlyByteBuf buffer, @Nonnull EmptyRecipe recipe) {
            //
        }
    }
    
    public static FinishedRecipe empty(ResourceLocation id) {
        
        return new FinishedRecipe() {

            @Override
            public void m_7917_(@Nonnull JsonObject json) {
                //
            }

            @Nonnull
            @Override
            public ResourceLocation m_6445_() {
                return id;
            }

            @Nonnull
            @Override
            public RecipeSerializer<?> m_6637_() {
                return Serializer.INSTANCE;
            }

            @Nullable
            @Override
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            @Override
            public ResourceLocation m_6448_() {
                return null;
            }
        };
    }
}
